<?php

use Carbon\Carbon;

if (! function_exists('financialYear')) {
    /**
     * Returns the Indian financial year (e.g., 2025-2026) for a given date
     *
     * @param string|\DateTime $date
     * @return string
     */
    function financialYear($date)
    {
        $created = Carbon::parse($date);
        $month = $created->month;
        $year = $created->year;

        if ($month >= 4) { // April to December
            return $year . '-' . ($year + 1);
        } else { // January to March
            return ($year - 1) . '-' . $year;
        }
    }
}
