<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AbattoirLicense;
use App\Services\CommonService;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\AbattoirLicenseService;
use App\Http\Requests\AbattoirLicense\CreateRequest;

class AbattoirLicenseController extends Controller
{
    protected $commonService;
    protected $abattoirLicenseService;


    // Constructor for dependency injection
    public function __construct(AbattoirLicenseService $abattoirLicense, CommonService $commonService)
    {
        $this->abattoirLicenseService = $abattoirLicense;
        $this->commonService = $commonService;
    }

    // Display the create form
    public function create()
    {
        // Get active wards and zones from CommonService
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        // Return the create view with wards and zones data
        return view('abattoir-license.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    // Store the newly created abattoir license
    public function store(Request $request)
    {
        // Call the store method in the service and get the response
        $abattoirLicense = $this->abattoirLicenseService->store($request);

        // Check if the license was successfully saved
        if ($abattoirLicense[0]) {
            return response()->json([
                'success' => 'Abattoir License saved successfully'
            ]);
        } else {
            return response()->json([
                'error' => $abattoirLicense[1]
            ]);
        }
    }



    public function edit($id)
    {
        //return encrypt($id);
        $abattoirLicense = $this->abattoirLicenseService->edit(decrypt($id));

        // $advertisementPermission = AdvertisementPermission::find($id);

        //  //return $advertisementPermission;

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('abattoir-license.update')->with([
            'wards' => $wards,
            'zones' => $zones,
            'abattoirLicense' => $abattoirLicense
        ]);
    }
    public function update(Request $request, $id)
    {
        // dd($request->all());
        $abattoirLicense = $this->abattoirLicenseService->update($request, $id);

        return response()->json(['success' => 'Health License update successfully!']);
    }

    public function show($id)
    {
        $data = abattoirLicense::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('abattoir-license.certificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }
}
