<?php

namespace App\Http\Controllers\ConstructionDepartment;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\ConstructionDepartment\DrainageConnectionService;
use App\Models\ConstructionDepartment\ConstructionDrainageConnection;
use App\Http\Requests\ConstructionDepartment\DrainageConnection\CreateRequest;
use App\Http\Requests\ConstructionDepartment\DrainageConnection\UpdateRequest;
use App\Models\WaterPayment;

class DrainageConnectionController extends Controller
{
    protected $drainageConnectionService;
    protected $commonService;

    public function __construct(DrainageConnectionService $drainageConnectionService, CommonService $commonService)
    {
        $this->drainageConnectionService = $drainageConnectionService;
        $this->commonService = $commonService;
    }
    public function index() {}

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $user = Auth::user();

        return view('construction-department.drainage-connection.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $drainageConnectionService = $this->drainageConnectionService->store($request);

        if ($drainageConnectionService) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

    public function edit(string $id)
    {
        $data = ConstructionDrainageConnection::findOrFail(decrypt($id));
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        $status = Status::where('table_id', decrypt($id))
        ->where('service_id', $data->service_id)
        ->first();


        return view('construction-department.drainage-connection.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
        ]);;
    }

    public function update(UpdateRequest $request, string $id)
    {
        $drainageConnectionService = $this->drainageConnectionService->update($request, $id);

        if ($drainageConnectionService) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

     public function show($id)
    {
        $data = ConstructionDrainageConnection::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('construction-department.drainage-connection.drainagecertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }


    public function generateReceipt($id)
    {
        $data = ConstructionDrainageConnection::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('construction-department.drainage-connection.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
