<?php

namespace App\Http\Controllers;

use App\Http\Requests\DemolishingProperty\CreateRequest;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\DemolishingProperty;
use App\Models\SbiPayment;
use App\Models\Status;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\DemolishingPropertyService;



class DemolishingPropertyController extends Controller
{
    protected $commonService;
    protected $demolishingproperty;


    public function __construct(DemolishingPropertyService $demolishingprop, CommonService $commonService)
    {
        $this->demolishingproperty = $demolishingprop;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();
        $user = Auth::user();

        return view('demolishing-property.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user'  => $user
        ]);
    }

    public function store(CreateRequest $request)
    {

        $demolishingprop = $this->demolishingproperty->store($request);
        if ($demolishingprop[0]) {
            return response()->json([
                'success' => 'Demolition and Reconstruction form submitted successfully.'
            ]);
        } else {
            return response()->json([
                'error' => $demolishingprop[1]
            ]);
        }
    }


    public function edit($id)
    {
        $demolishingprop = $this->demolishingproperty->edit(decrypt($id));
        $status = Status::where('table_id', $demolishingprop->id)
            ->where('service_id', $demolishingprop->service_id)
            ->first();
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('demolishing-property.update')->with([
            'demolishingprop' =>  $demolishingprop,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
            'advertisemenent' => $demolishingprop
        ]);
    }

    public function update(Request $request, $id)
    {
        // dd($request->all());
        $demolishingprop = $this->demolishingproperty->update($request, $id);

        return response()->json(['success' => 'Demolishing and Reconstrction update successfully!']);
    }

    public function show($id)
    {
        $data = DemolishingProperty::with('user')->findOrFail(decrypt($id));
        $pdf = SnappyPdf::loadView('demolishing-property.demolishingcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
            // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = DemolishingProperty::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('demolishing-property.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
