<?php

namespace App\Http\Controllers\DrinageWater;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\DrinageWater\PortableWater;
use App\Services\DrinageWater\PortableWaterService;
use App\Http\Requests\DrinageWater\PortableWater\CreateRequest;
use App\Http\Requests\DrinageWater\PortableWater\UpdateRequest;



class PortableWaterController extends Controller
{
    protected $waterQualityService;
    protected $commonService;

    public function __construct(PortableWaterService $waterQualityService, CommonService $commonService)
    {
        $this->waterQualityService = $waterQualityService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('DrinageWater.PortableWater.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $waterQualityService = $this->waterQualityService->store($request);

        if ($waterQualityService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $waterQualityService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
        $id = decrypt($id);
        $data = PortableWater::findOrFail($id);
        $status = Status::where('table_id', $id)
            ->where('service_id', $data->service_id)
            ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('DrinageWater.PortableWater.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $waterQualityService = $this->waterQualityService->update($request, $id);

        if ($waterQualityService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $waterQualityService[1]
            ]);
        }
    }

     public function show($id)
    {
        $data = PortableWater::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('DrinageWater.PortableWater.portablewatercertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = PortableWater::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('DrinageWater.PortableWater.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }

}
