<?php

namespace App\Http\Controllers\DrinageWater;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;

// use Illuminate\Http\Request;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\DrinageWater\SewerageProperty;
use App\Services\DrinageWater\SeweragePropertiesService;
use App\Http\Requests\DrinageWater\SewerageProperties\CreateRequest;
use App\Http\Requests\DrinageWater\SewerageProperties\UpdateRequest;

class SeweragePropertiesController extends Controller
{
    protected $commonService;
    protected $sewerageproperties;

     public function __construct(SeweragePropertiesService $sewerageproperties, CommonService $commonService)
    {
        $this->sewerageproperties = $sewerageproperties;
        $this->commonService = $commonService;
    }


    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {
    //     //
    // }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('DrinageWater.sewerageproperty.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        $sewerageproperties = $this->sewerageproperties->store($request);
        if ($sewerageproperties[0]) {
            return response()->json([
                'success' => 'Sewerage Property record saved successfully.'
            ]);
        } else {
            return response()->json([
                'error' => $sewerageproperties[1]
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    // public function show(string $id)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $id = decrypt($id);
        $sewerageproperties = SewerageProperty::findOrFail($id);
        $status = Status::where('table_id', $id)
            ->where('service_id', $sewerageproperties->service_id)
            ->first();
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('DrinageWater.sewerageproperty.update')->with([
            'sewerageproperties' => $sewerageproperties,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
       $updated = $this->sewerageproperties->update($request, $id);

        if ($updated[0]) {
            return response()->json(['success' => 'Sewerage Properties updated successfully!']);
        } else {
            return response()->json(['error' => $updated[1]]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    // public function destroy(string $id)
    // {
    //     //
    // }

    // public function show_old($id)
    // {

    //     $data = SewerageProperty::with('user')->findOrFail(decrypt($id));
    //     $pdf = SnappyPdf::loadView('DrinageWater.sewerageproperty.sewerageproperty', ['data' => $data]);
    //     $pdf->setPaper('a4')
    //         ->setOption('margin-top', 10)
    //         ->setOption('margin-bottom', 10)
    //         ->setOption('margin-left', 5)
    //         ->setOption('margin-right', 5)
    //         ->setOption('enable-smart-shrinking', true)
    //         ->setOption('disable-smart-shrinking', false)
    //         ->setOption('no-stop-slow-scripts', true)
    //          // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
    //         ->setOption('footer-left', 'Page: [page] of [toPage]');
    //     return $pdf->inline('certificate.pdf');
    // }
    public function show($id)
{
    // 1️⃣ Get main record
    $data = SewerageProperty::with('user')->findOrFail(decrypt($id));

    // 2️⃣ Get matching payment data from SbiPayment
    $paymentdata = SbiPayment::where('table_id', $data->id)
        ->where('service_id', $data->service_id)
        ->first();

    // 3️⃣ Get amount (default 0 if not found)
    $amount = $paymentdata ? $paymentdata->amount : 0;

    // 4️⃣ Convert amount to Marathi words (optional but nice)
 function convertNumberToWords($number) {
    $words = [
        0 => 'शून्य', 1 => 'एक', 2 => 'दोन', 3 => 'तीन', 4 => 'चार', 5 => 'पाच',
        6 => 'सहा', 7 => 'सात', 8 => 'आठ', 9 => 'नऊ', 10 => 'दहा',
        1000 => 'हजार', 100000 => 'लाख', 10000000 => 'कोटी'
    ];

    if ($number == 0) return 'शून्य रुपये मात्र';

    // Basic example — (full Marathi formatter custom बना सकता हूँ अगर चाहिए)
    return $number . ' रुपये मात्र';
}

    $amount_in_words = convertNumberToWords($amount);
   

    // 5️⃣ Load view and pass all data
    $pdf = SnappyPdf::loadView('DrinageWater.sewerageproperty.sewerageproperty', [
        'data' => $data,
        'paymentdata' => $paymentdata,
        'amount' => $amount,
        'amount_in_words' => $amount_in_words,
    ]);

    // 6️⃣ PDF layout options
    $pdf->setPaper('a4')
        ->setOption('margin-top', 10)
        ->setOption('margin-bottom', 10)
        ->setOption('margin-left', 5)
        ->setOption('margin-right', 5)
        ->setOption('enable-smart-shrinking', true)
        ->setOption('disable-smart-shrinking', false)
        ->setOption('no-stop-slow-scripts', true)
        ->setOption('footer-left', 'Page: [page] of [toPage]');

    // 7️⃣ Return PDF inline
    return $pdf->inline('certificate.pdf');
}

     public function generateReceipt($id)
    {
        $data = SewerageProperty::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        
        $pdf = SnappyPdf::loadView('DrinageWater.sewerageproperty.receipt', ['data' => $data , 'paymentdata'=>$paymentdata]);


        $data = SewerageProperty::with('user')->findOrFail(decrypt($id));

$paymentdata = SbiPayment::where('table_id', $data->id)
    ->where('service_id', $data->service_id)
    ->first();



$pdf = SnappyPdf::loadView('DrinageWater.sewerageproperty.receipt', [
    'data' => $data,
    'paymentdata' => $paymentdata,
  
]);





        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
