<?php

namespace App\Http\Controllers\DrinageWater;

use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use App\Models\DrinageWater\WaterDues;
// use Illuminate\Http\Request;
use App\Models\Status;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\DrinageWater\WaterDuesService;
use App\Http\Requests\DrinageWater\WaterDues\CreateRequest;
use App\Http\Requests\DrinageWater\WaterDues\UpdateRequest;

class WaterDuesController extends Controller
{
    protected $commonService;
    protected $waterdues;

    public function __construct(WaterDuesService $waterdues, CommonService $commonService)
    {
        $this->waterdues = $waterdues;
        $this->commonService = $commonService;
    }
    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {
    //     //
    // }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('DrinageWater.waterdues.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        $waterdues = $this->waterdues->store($request);
        if ($waterdues[0]) {
            return response()->json([
                'success' => 'Water Dues record saved successfully.'
            ]);
        } else {
            return response()->json([
                'error' => $waterdues[1]
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    // public function show(string $id)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     */
    // public function edit_old(string $id)
    // {
    //     $waterdues = $this->waterdues->edit(decrypt($id));
    //     $wards = $this->commonService->getActiveWard();
    //     $zones = $this->commonService->getActiveZone();

    //     return view('DrinageWater.waterdues.update')->with([
    //         'waterdues' => $waterdues,
    //         'wards' => $wards,
    //         'zones' => $zones,
    //     ]);
    // }

    public function edit(string $id)
{
    $id = decrypt($id);

    $data = WaterDues::findOrFail($id);
    $status = Status::where('table_id', $id)
              ->where('service_id', $data->service_id)
              ->first();

    $waterdues = $this->waterdues->edit($id); // already decrypted
    $wards = $this->commonService->getActiveWard();
    $zones = $this->commonService->getActiveZone();

    return view('DrinageWater.waterdues.update')->with([
        'waterdues' => $waterdues,
        'wards' => $wards,
        'zones' => $zones,
        'status' => $status
    ]);
}

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
         $updated = $this->waterdues->update($request, $id);

        if ($updated[0]) {
            return response()->json(['success' => 'Water Dues updated successfully!']);
        } else {
            return response()->json(['error' => $updated[1]]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    // public function destroy(string $id)
    // {
    //     //
    // }

    public function show($id)
    {

        $data = WaterDues::with('user')->findOrFail(decrypt($id));
        $pdf = SnappyPdf::loadView('DrinageWater.waterdues.waterduescertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = WaterDues::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('DrinageWater.waterdues.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
