<?php

namespace App\Http\Controllers\DrinageWater;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\DrinageWater\WaterTransfer;
use App\Services\DrinageWater\WaterTransferService;
use App\Http\Requests\DrinageWater\WaterTransfer\CreateRequest;
use App\Http\Requests\DrinageWater\WaterTransfer\UpdateRequest;

class WaterTransferController extends Controller
{
    protected $commonService;
    protected $stromwaterdrains;

    public function __construct(WaterTransferService $stromwaterdrains, CommonService $commonService)
    {
        $this->stromwaterdrains = $stromwaterdrains;
        $this->commonService = $commonService;
    }

    /**
     *
     *
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('DrinageWater.WaterTransfer.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        $stromwaterdrain = $this->stromwaterdrains->store($request);
        if ($stromwaterdrain[0]) {
            return response()->json([
                'success' => 'Details saved successfully.'
            ]);
        } else {
            return response()->json([
                'error' => $stromwaterdrain[1]
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $id = decrypt($id);
        $data = WaterTransfer::findOrFail($id);
        $status = Status::where('table_id', $id)
            ->where('service_id', $data->service_id)
            ->first();

        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('DrinageWater.WaterTransfer.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
        $updated = $this->stromwaterdrains->update($request, $id);

        if ($updated[0]) {
            return response()->json(['success' => 'Details updated successfully!']);
        } else {
            return response()->json(['error' => $updated[1]]);
        }
    }

    public function show($id)
    {

        $data = WaterTransfer::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('DrinageWater.WaterTransfer.watertransfer', ['data' => $data,'paymentdata'=>$paymentdata]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = WaterTransfer::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('DrinageWater.WaterTransfer.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
