<?php

namespace App\Http\Controllers\EstateVibhag;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\ES\ElectricMeterTransferService;
use App\Models\EstateVibhag\ElectricMeterNameTransfer;
use App\Http\Requests\EstateVibhag\ElectricMeterName\CreateRequest;
use App\Http\Requests\EstateVibhag\ElectricMeterName\UpdateRequest;

class ElectricMeterNameTransferController extends Controller
{
    protected $commonService;
    protected $electricmetertransfer;

    public function __construct( ElectricMeterTransferService $electricmetertransfer, CommonService $commonService) {
        $this->electricmetertransfer = $electricmetertransfer;
        $this->commonService = $commonService;
    }

    /**
     * Show the form for creating a new Electric Meter Transfer.
     */
    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('EstateVibhag.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created Electric Meter Transfer.
     */
    public function store(CreateRequest $request)
    {
        $result = $this->electricmetertransfer->store($request);

        if ($result[0]) {
            return response()->json(['success' => 'Electric Meter Name transfer record saved successfully.']);
        } else {
            return response()->json(['error' => $result[1]]);
        }
    }

    /**
     * Show the form for editing the Electric Meter Transfer.
     */
    public function edit(string $id)
    {

        $id = decrypt($id);
        $electricmetertransfer = ElectricMeterNameTransfer::findOrFail($id);
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();
        $status = Status::where('table_id', $id)
        ->where('service_id', $electricmetertransfer->service_id)
        ->first();

        return view('EstateVibhag.update')->with([
            'electricmetertransfer' => $electricmetertransfer,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    /**
     * Update the Electric Meter Transfer.
     */
    public function update(UpdateRequest $request, $id)
    {
        $result = $this->electricmetertransfer->update($request, $id);

        if ($result[0]) {
            return response()->json(['success' => 'Electric meter name transfer updated successfully.']);
        } else {
            return response()->json(['error' => $result[1]]);
        }
    }

    /**
     * Generate and display the certificate PDF.
     */
    public function show($id)
    {
        $data = ElectricMeterNameTransfer::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('EstateVibhag.electricmeternametransfercertificate', [
            'data' => $data,
        ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = ElectricMeterNameTransfer::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('EstateVibhag.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
