<?php

namespace App\Http\Controllers\EstateVibhag;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\ApprovalHierarchies;
use App\Http\Controllers\Controller;
use App\Services\ES\SolarPowerService;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\EstateVibhag\SolarPower;
use App\Http\Requests\EstateVibhag\SolarPower\CreateRequest;
use App\Http\Requests\EstateVibhag\SolarPower\UpdateRequest;

class SolarPowerController extends Controller
{
    protected $commonService;
    protected $electricmetertransfer;

    public function __construct(SolarPowerService $electricmetertransfer, CommonService $commonService) {
        $this->electricmetertransfer = $electricmetertransfer;
        $this->commonService = $commonService;
    }

    /**
     * Show the form for creating a new Electric Meter Transfer.
     */
    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('SolarPower.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created Electric Meter Transfer.
     */
    public function store(CreateRequest $request)
    {
        $result = $this->electricmetertransfer->store($request);

        if ($result[0]) {
            return response()->json(['success' => 'Solar Power record saved successfully.']);
        } else {
            return response()->json(['error' => $result[1]]);
        }
    }

    /**
     * Show the form for editing the Electric Meter Transfer.
     */
    public function edit(string $id)
    {
        $electricmetertransfer = $this->electricmetertransfer->edit(decrypt($id));
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();
         $status = Status::where('table_id', decrypt($id))
         //8930
         //3
        ->where('service_id', $electricmetertransfer->service_id)
        ->first();
    $approvaldata = ApprovalHierarchies::where('service_id',$electricmetertransfer->service_id)->where('table_id',$id)->get();


        return view('SolarPower.update')->with([
            'electricmetertransfer' => $electricmetertransfer,
            'wards' => $wards,
            'zones' => $zones,
            'approvaldata' => $approvaldata,
            'status' => $status
        ]);
    }

    /**
     * Update the Electric Meter Transfer.
     */
    public function update(UpdateRequest $request, $id)
    {
        $result = $this->electricmetertransfer->update($request, $id);

        if ($result[0]) {
            return response()->json(['success' => 'Solar Power updated successfully.']);
        } else {
            return response()->json(['error' => $result[1]]);
        }
    }

    /**
     * Generate and display the certificate PDF.
     */
    public function show($id)
    {
        $data = SolarPower::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('SolarPower.solarpowercertificate', [
            'data' => $data,
        ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('certificate.pdf');
    }
     public function generateReceipt($id)
    {
        $data = SolarPower::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('SolarPower.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
