<?php
namespace App\Http\Controllers;
use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\AdvertisementTypes;
use App\Models\HoardingPermission;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\HoardingPermissionService;
use App\Http\Requests\HoardingPermission\CreateRequest;
use App\Http\Requests\HoardingPermission\UpdateRequest;
use SimpleSoftwareIO\QrCode\Facades\QrCode;
use function PHPUnit\Framework\returnSelf;

class HoardingPermissionController extends Controller
{
    protected $commonService;
    protected $HoardingPermissionService;


    public function __construct(HoardingPermissionService $hoardingPermission, CommonService $commonService)
    {
        $this->HoardingPermissionService = $hoardingPermission;
        $this->commonService = $commonService;
    }


    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $advertisement =  AdvertisementTypes::get();

        $zones = $this->commonService->getActiveZone();

        return view('hoarding-permission.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'advertisement' => $advertisement
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        //dd($request->all());
        $hoardingPermission = $this->HoardingPermissionService->store($request);

        if ($hoardingPermission[0]) {
            return response()->json([
                'success' => 'Hoarding Permission save successfully'
            ]);
        } else {
            return response()->json([
                'error' => $hoardingPermission[1]
            ]);
        }
    }

    /**
     * Display the specified resource.
     */


    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {


        $id = decrypt($id);
        $hoardingPermission = HoardingPermission::findOrFail($id);
        $status = Status::where('table_id', $id)
        ->where('service_id', $hoardingPermission->service_id)
        ->first();

        $wards = $this->commonService->getActiveWard();

        $advertisement =  AdvertisementTypes::get();

        $zones = $this->commonService->getActiveZone();

        return view('hoarding-permission.update')->with([
            'wards' => $wards,
            'zones' => $zones,
            'hoardingPermission' => $hoardingPermission,
            'status' => $status,
            'advertisement' => $advertisement

        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
        $hoardingPermission = $this->HoardingPermissionService->update($request, $id);

      if ($hoardingPermission) {
        return response()->json([
            'success' => 'Hoarding Permission updated successfully'
        ]);
    } else {
        return response()->json([
            'error' => 'Something went wrong, please try again'
        ]);
    }
}


        public function hoardingdetails($id)
        {
            $data = HoardingPermission::with('user')->findOrFail($id);
             $typerate = AdvertisementTypes::where('id', $data->type_hoarding)->first();

            return view('hoarding-permission.hoardingdetails')->with([
                'data' => $data,
                'typerate' => $typerate
            ]);
        }




    public function show($id)
    {
        $data = HoardingPermission::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $length = $data->plot_no;
        $width = $data->size_hoarding;
        $area =  $length * $width;
        $typerate = AdvertisementTypes::where('id', $data->type_hoarding)->first();
        $bannerrate = $area * $typerate->rate;
        $yearrate = $bannerrate * 12;
        $rateper = $yearrate * 0.2;
        $sumrate = $yearrate + $rateper;
        $halfsum = $sumrate/ 2;
        $totalrate = $sumrate + $halfsum;

        $pdf = SnappyPdf::loadView('hoarding-permission.certificate', [
            'data' => $data,
            'totalrate' => $totalrate,
            'paymentdata' => $paymentdata,
        ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('certificate.pdf');
    }


    public function generateReceipt($id)
    {
        $data = HoardingPermission::with('user')->findOrFail(decrypt($id));
           $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('hoarding-permission.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }

     public function generatedemandnote($id)
    {
        $data = HoardingPermission::with('user')->findOrFail(decrypt($id));
        $length = $data->plot_no;
        $width =$data->size_hoarding;
        $area =  $length * $width;
        $typerate = AdvertisementTypes::where('id', $data->type_hoarding)->first();
        $bannerrate = $area * $typerate->rate;
        $yearrate = $bannerrate * 12;
        $rateper = $yearrate * 0.2;
        //$sumrate = $yearrate + $rateper;
        $sumrate = ($yearrate + $rateper) / 2;
        $anamat = $yearrate * 0.5;
       //$halfsum = $sumrate / 2;
       //$halfsum = $sumrate * 12;
        $totalrate = $sumrate + $anamat;

        return SnappyPdf::loadView('hoarding-permission.demandnote', [
            'data' => $data,
            'length' => $length,
            'width' => $width,
            'area' => $area,
            'bannerrate' => $bannerrate,
            'yearrate' => $yearrate,
            'rateper' => $rateper,
            'sumrate' => $sumrate,
          //'halfsum' => $halfsum,
            'anamat'=> $anamat,
            'totalrate' => $totalrate
        ])->inline('demandnote.pdf');
    }


}
