<?php

namespace App\Http\Controllers\InsuranceOfBirthController;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\InsuranceOfBirthCertificate\InsuranceBirth;
use App\Services\InsuranceofBirth\InsuranceOfBirthService;
use App\Http\Requests\InsuranceOfBirthCertificate\InsuranceofBirth\CreateRequest;
use App\Http\Requests\InsuranceOfBirthCertificate\InsuranceOfBirth\UpdateRequest;

class InsuranceOfBirthReadingController extends Controller
{
    protected $commonService;
    protected $insuranceofbirthreading;

    public function __construct(InsuranceOfBirthService $insuranceofbirthreading, CommonService $commonService)
    {
        $this->insuranceofbirthreading = $insuranceofbirthreading;
        $this->commonService = $commonService;
    }

    /**
     * Display a listing of the resource.
     */
    // public function index()
    // {
    //     //
    // }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
       $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('insuranceofbirth.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        $result = $this->insuranceofbirthreading->store($request);

        if ($result[0]) {
            return response()->json(['success' => 'Birth Insurance record saved successfully.']);
        } else {
            return response()->json(['error' => $result[1]]);
        }
    }

    /**
     * Display the specified resource.
     */
    // public function show(string $id)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
         $id = decrypt($id);
        $insuranceofbirthreading = InsuranceBirth::findOrFail($id);;
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        $status = Status::where('table_id', $id)
        ->where('service_id', $insuranceofbirthreading->service_id)
        ->first();

        return view('insuranceofbirth.update')->with([
            'insuranceofbirthreading' => $insuranceofbirthreading,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
       $insuranceofbirthreading = $this->insuranceofbirthreading->update($request, $id);

        if ($insuranceofbirthreading[0]) {
            return response()->json(['success' => 'insurance of birth reading record updated successfully.']);
        } else {
            return response()->json(['error' => $insuranceofbirthreading[1]]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    // public function destroy(string $id)
    // {
    //     //
    // }

    public function show($id)
    {
        ini_set('memory_limit', '-1');
        $data =InsuranceBirth::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('insuranceofbirth.insuranceofbirthcertificate', [
            'data' => $data,
        ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = InsuranceBirth::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('insuranceofbirth.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
