<?php

namespace App\Http\Controllers\InsuranceOfBirthController;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\InsuranceOfBirthCertificate\InsuranceDeath;
use App\Services\InsuranceofBirth\InsuranceOfDeathService;
use App\Http\Requests\InsuranceOfBirthCertificate\InsuranceOfDeath\CreateRequest;
use App\Http\Requests\InsuranceOfBirthCertificate\InsuranceOfDeath\UpdateRequest;

class InsuranceOfDeathReadingController extends Controller
{
    protected $commonService;
    protected $insuranceofdeathreading;

     public function __construct(InsuranceOfDeathService $insuranceofdeathreading, CommonService $commonService)
    {
        $this->insuranceofdeathreading = $insuranceofdeathreading;
        $this->commonService = $commonService;
    }


    // public function index()
    // {
    //     //
    // }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
       $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();


        return view('insuranceofdeath.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        $result = $this->insuranceofdeathreading->store($request);

        if ($result[0]) {
            return response()->json(['success' => 'Death Insurance record saved successfully.']);
        } else {
            return response()->json(['error' => $result[1]]);
        }
    }

    /**
     * Display the specified resource.
     */
    // public function show(string $id)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {

        $id = decrypt($id);
        $insuranceofdeathreading = InsuranceDeath::findOrFail($id);
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        $status = Status::where('table_id', $id)
        ->where('service_id', $insuranceofdeathreading->service_id)
        ->first();

        return view('insuranceofdeath.update')->with([
            'insuranceofdeathreading' => $insuranceofdeathreading,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
        $insuranceofdeathreading = $this->insuranceofdeathreading->update($request, $id);

        if ($insuranceofdeathreading[0]) {
            return response()->json(['success' => 'insurance of death reading record updated successfully.']);
        } else {
            return response()->json(['error' => $insuranceofdeathreading[1]]);
        }
    }


    /**
     * Remove the specified resource from storage.
     */
    // public function destroy(string $id)
    // {
    //     //
    // }

     public function show($id)
    {
        $data =InsuranceDeath::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('insuranceofdeath.insuranceofdeathcertificate', ['data' => $data,]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = InsuranceDeath::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('insuranceofdeath.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
