<?php

namespace App\Http\Controllers\MedicalHealth;

use App\Models\Status;
use Illuminate\Http\Request;
use GuzzleHttp\Promise\Create;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\MedicalHealth\ChangeNursingLicense;
use App\Services\MedicalHealth\ChangeNursingLicenseService;
use App\Http\Requests\MedicalHealth\ChangelNursingLicense\CreateRequest;
use App\Http\Requests\MedicalHealth\ChangelNursingLicense\UpdateRequest;


class ChangeNursingLicenseController extends Controller
{
    protected $commonService;
    protected $changeNursingLicense;


    // Constructor for dependency injection
    public function __construct(ChangeNursingLicenseService $changeNursingLicense, CommonService $commonService)
    {
        $this->changeNursingLicense = $changeNursingLicense;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('medical-health.changenursing-license.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {

        $changeNursingLicense = $this->changeNursingLicense->store($request);

        if ($changeNursingLicense[0]) {
            return response()->json([
                'success' => 'Change Nursing License saved successfully'
            ]);
        } else {
            return response()->json([
                'error' => $changeNursingLicense[1]
            ]);
        }
    }



    public function edit($id)
    {
        $id = decrypt($id);
        $changeNursingLicense = ChangeNursingLicense::findOrFail($id);
        $status = Status::where('table_id', $id)
            ->where('service_id', $changeNursingLicense->service_id)
            ->first();
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('medical-health.changenursing-license.update')->with([
            'changeNursingLicense' =>  $changeNursingLicense,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
        ]);
    }
    public function update(UpdateRequest $request, $id)
    {
        // dd($request->all());
        $changeNursingLicense = $this->changeNursingLicense->update($request, $id);

        if ($changeNursingLicense) {
            return response()->json([
                'success' => 'Change Nursing License updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

      public function show($id)
    {
        $data = ChangeNursingLicense::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('medical-health.changenursing-license.changenursingcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }
}
