<?php

namespace App\Http\Controllers\MedicalHealth;

use App\Models\Status;
use App\Models\CityClean;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use GuzzleHttp\Promise\Create;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\MedicalHealth\CityCleanService;
use App\Http\Requests\MedicalHealth\CityClean\CreateRequest;
use App\Http\Requests\MedicalHealth\CityClean\UpdateRequest;




class CityCleanControllerController extends Controller
{
    protected $commonService;
    protected $grantNursingLicense;


    public function __construct(CityCleanService $grantNursingLicense, CommonService $commonService)
    {
        $this->grantNursingLicense = $grantNursingLicense;
        $this->commonService = $commonService;
    }


    public function create()
    {

        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();


        return view('medical-health.CityClean.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }


    public function store(CreateRequest $request)
    {

        $grantNursingLicense = $this->grantNursingLicense->store($request);

        if ($grantNursingLicense[0]) {
            return response()->json([
                'success' => 'City Clean saved successfully'
            ]);
        } else {
            return response()->json([
                'error' => $grantNursingLicense[1]
            ]);
        }
    }



    public function edit($id)
    {
        $id = decrypt($id);
        $data = CityClean::findOrFail($id);
        $status = Status::where('table_id', $id)
            ->where('service_id', $data->service_id)
            ->first();
        return view('medical-health.CityClean.update')->with([
            'data' =>  $data,
            'status' => $status
        ]);
    }

    public function update(UpdateRequest $request, $id)
    {
        $grantNursingLicense = $this->grantNursingLicense->update($request, $id);

        if ($grantNursingLicense) {
            return response()->json([
                'success' => 'City Clean updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

    public function show($id)
    {
        $data = CityClean::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('medical-health.CityClean.certificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
            // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = CityClean::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id', $data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('PwdElectrical.Completition-Certificate-Development.receipt', ['data' => $data, 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
            // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
