<?php

namespace App\Http\Controllers\MedicalHealth;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use GuzzleHttp\Promise\Create;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\MedicalHealth\CivilLocalSelfGovermentServices;
use App\Models\MedicalHealth\CivilLocalSelfGovernmentNomination;
use App\Http\Requests\MedicalHealth\CivilLocalSelfGoverment\CreateRequest;
use App\Http\Requests\MedicalHealth\CivilLocalSelfGoverment\UpdateRequest;


class CivilLocalSelfGovermentNominationController extends Controller
{
    protected $commonService;
    protected $civillocalselfgovernment;

    public function __construct(CivilLocalSelfGovermentServices $civillocalselfgovernment, CommonService $commonService)
    {
        $this->civillocalselfgovernment = $civillocalselfgovernment;
        $this->commonService = $commonService;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('medical-health.civil-government.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        $civillocalselfgovernment = $this->civillocalselfgovernment->store($request);
        if ($civillocalselfgovernment[0]) {
            return response()->json([
                'success' => 'Civil Local Self Government Saved Successfully'
            ]);
        } else {
            return response()->json([
                'error' => $civillocalselfgovernment[1]
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    // public function show(string $id)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $id = decrypt($id);
        $civillocalselfgovernment = CivilLocalSelfGovernmentNomination::findOrFail($id);
        $status = Status::where('table_id', $id)
            ->where('service_id', $civillocalselfgovernment->service_id)
            ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('medical-health.civil-government.update')->with([
            'civillocalselfgovernment' =>  $civillocalselfgovernment,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

     public function generateReceipt($id)
    {
        $data = CivilLocalSelfGovernmentNomination::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('medical-health.civil-government.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
        $civillocalselfgovernment = $this->civillocalselfgovernment->update($request, $id);

        if ($civillocalselfgovernment) {
            return response()->json([
                'success' => 'Civil Local Self Government updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }    }


        public function show($id)
        {
        $data = CivilLocalSelfGovernmentNomination::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('medical-health.civil-government.civillocalselfcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
      }
    /**
     * Remove the specified resource from storage.
     */
    // public function destroy(string $id)
    // {
    //     //
    // }
}
