<?php

namespace App\Http\Controllers\MedicalHealth;

use App\Models\Status;
use Illuminate\Http\Request;
use GuzzleHttp\Promise\Create;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\MedicalHealth\GrantNursingLicense;
use App\Services\MedicalHealth\GrantNursingLicenseService;
use App\Http\Requests\MedicalHealth\GrantNursingLicense\CreateRequest;
use App\Http\Requests\MedicalHealth\GrantNursingLicense\UpdateRequest;
use App\Models\SbiPayment;

class GrantNursingLicenseController extends Controller
{
    protected $commonService;
    protected $grantNursingLicense;


    public function __construct(GrantNursingLicenseService $grantNursingLicense, CommonService $commonService)
    {
        $this->grantNursingLicense = $grantNursingLicense;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('medical-health.grantnursing-license.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {

        $grantNursingLicense = $this->grantNursingLicense->store($request);

        if ($grantNursingLicense[0]) {
            return response()->json([
                'success' => 'Grant Nursing License saved successfully'
            ]);
        } else {
            return response()->json([
                'error' => $grantNursingLicense[1]
            ]);
        }
    }



    public function edit($id)
    {
        $id = decrypt($id);
        $grantNursingLicense = GrantNursingLicense::findOrFail($id);
        $status = Status::where('table_id', $id)
            ->where('service_id', $grantNursingLicense->service_id)
            ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('medical-health.grantnursing-license.update')->with([
            'grantNursingLicense' =>  $grantNursingLicense,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }
    public function update(UpdateRequest $request, $id)
    {
        $grantNursingLicense = $this->grantNursingLicense->update($request, $id);

        if ($grantNursingLicense) {
            return response()->json([
                'success' => 'Grant Nursing License updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

     public function show($id)
    {
        $data = GrantNursingLicense::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('medical-health.grantnursing-license.grantnursingcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = GrantNursingLicense::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id', $data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('medical-health.grantnursing-license.receipt', ['data' => $data, 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 5)
            ->setOption('margin-bottom', 5)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
            // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }

}
