<?php

namespace App\Http\Controllers\MedicalHealth;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use GuzzleHttp\Promise\Create;
use App\Services\CommonService;
use App\Models\ApprovalHierarchies;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\MedicalHealth\GutterCover;
use App\Services\MedicalHealth\GutterCoverService;
use App\Http\Requests\MedicalHealth\GutterCover\CreateRequest;
use App\Http\Requests\MedicalHealth\GutterCover\UpdateRequest;




class GutterCoverController extends Controller
{
    protected $commonService;
    protected $grantNursingLicense;


    public function __construct(GutterCoverService $grantNursingLicense, CommonService $commonService)
    {
        $this->grantNursingLicense = $grantNursingLicense;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('medical-health.GutterCover.create')->with([
            'options' => $options,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {

        $grantNursingLicense = $this->grantNursingLicense->store($request);
        if ($grantNursingLicense[0]) {
            return response()->json([
                'success' => 'Application Submitted Successfully'
            ]);
        } else {
            return response()->json([
                'error' => $grantNursingLicense[1]
            ]);
        }
    }



    public function edit($id)
    {
        $id = decrypt($id);
        $grantNursingLicense = GutterCover::findOrFail($id);
        $options = $this->commonService->getActiveWard();

        $status = Status::where('table_id', $id)
        ->where('service_id', $grantNursingLicense->service_id)
        ->first();

        $approvaldata = ApprovalHierarchies::where('service_id',$grantNursingLicense->service_id)->where('table_id',$id)->get();


        $zones = $this->commonService->getActiveZone();
        return view('medical-health.GutterCover.update')->with([
            'grantNursingLicense' =>  $grantNursingLicense,
            'options' => $options,
            'zones' => $zones,
            'status'  =>  $status,
            'approvaldata' => $approvaldata
        ]);
    }
    public function update(UpdateRequest $request, $id)
    {
        $grantNursingLicense = $this->grantNursingLicense->update($request, $id);

        if ($grantNursingLicense) {
            return response()->json([
                'success' => 'Details updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

     public function show($id)
    {
        $data = GutterCover::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('medical-health.GutterCover.guttercovercertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = GutterCover::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();

        $pdf = SnappyPdf::loadView('medical-health.GutterCover.receipt', ['data' => $data , 'paymentdata'=> $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }

}
