<?php

namespace App\Http\Controllers\MedicalHealth;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\MedicalHealth\RenewalNursingLicense;
use App\Services\MedicalHealth\RenewalNursingLicenseService;
use App\Http\Requests\MedicalHealth\RenewalNursingLicense\CreateRequest;
use App\Http\Requests\MedicalHealth\RenewalNursingLicense\UpdateRequest;


class RenewalNursingLicenseController extends Controller
{
    protected $commonService;
    protected $renewNursingLicense;


    public function __construct(RenewalNursingLicenseService $renewNursingLicense, CommonService $commonService)
    {
        $this->renewNursingLicense = $renewNursingLicense;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('medical-health.renewnursing-license.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    // Store the newly created abattoir license
    public function store(CreateRequest $request)
    {

        // Call the store method in the service and get the response
        $renewNursingLicense = $this->renewNursingLicense->store($request);

        // dd($request);
        // Check if the license was successfully saved
        if ($renewNursingLicense[0]) {
            return response()->json([
                'success' => 'Renewal Nursing License saved successfully'
            ]);
        } else {
            return response()->json([
                'error' => $renewNursingLicense[1]
            ]);
        }
    }



    public function edit($id)
    {

        $id = decrypt($id);
        $renewNursingLicense = RenewalNursingLicense::findOrFail($id);
        $status = Status::where('table_id', $id)
            ->where('service_id', $renewNursingLicense->service_id)
            ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();


        return view('medical-health.renewnursing-license.update')->with([
            'renewNursingLicense' =>  $renewNursingLicense,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
        ]);
    }
    public function update(UpdateRequest $request, $id)
    {
        // dd($request->all());
        $renewNursingLicense = $this->renewNursingLicense->update($request, $id);

        if ($renewNursingLicense) {
            return response()->json([
                'success' => 'Renewal Nursing License updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

      public function show($id)
    {
        $data = RenewalNursingLicense::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('medical-health.renewnursing-license.renewnursingcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = RenewalNursingLicense::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('medical-health.renewnursing-license.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
