<?php

namespace App\Http\Controllers\PwdElectrical;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\ApprovalHierarchies;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PwdElectrical\CompletionCertificateDevelopment;
use App\Services\Pwd\CompletitionCertificateDevelopmentService;
use App\Http\Requests\PwdElectrical\CompletitionCertificate\CreateRequest;
use App\Http\Requests\PwdElectrical\CompletitionCertificate\UpdateRequest;

class CompletitionCertificateDevelopmentController extends Controller
{
    protected $commonService;
    protected $completitioncertificate;

    public function __construct(CompletitionCertificateDevelopmentService $completitioncertificate, CommonService $commonService)
    {
        $this->completitioncertificate = $completitioncertificate;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('PwdElectrical.Completition-Certificate-Development.create')->with([
            'options' => $options,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $completitioncertificate = $this->completitioncertificate->store($request);

        if ($completitioncertificate[0]) {
            return response()->json([
                'success' => 'Application Submitted Successfully'
            ]);
        } else {
            return response()->json([
                'error' => $completitioncertificate[1]
            ]);
        }
    }

    public function edit(string $id)
    {
        $id = decrypt($id);
        $completitioncertificate = CompletionCertificateDevelopment::findOrFail($id);
        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();
         $status = Status::where('table_id', $id)
        ->where('service_id', $completitioncertificate->service_id)
        ->first();

                $approvaldata = ApprovalHierarchies::where('service_id',$completitioncertificate->service_id)->where('table_id',$id)->get();


        return view('PwdElectrical.Completition-Certificate-Development.update')->with([
            'completitioncertificate' => $completitioncertificate,
            'options' => $options,
            'zones' => $zones,
            'status' => $status,
            'approvaldata' => $approvaldata
        ]);
    }

    public function update(UpdateRequest $request, $id)
    {
        $updated = $this->completitioncertificate->update($request, $id);

        if ($updated[0]) {
            return response()->json(['success' => 'Completition Certificate Development updated successfully!']);
        } else {
            return response()->json(['error' => $updated[1]]);
        }
    }

    public function show($id)
    {
        $data = CompletionCertificateDevelopment::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('PwdElectrical.Completition-Certificate-Development.completitioncertificatedevelopment', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = CompletionCertificateDevelopment::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('PwdElectrical.Completition-Certificate-Development.receipt', ['data' => $data , 'paymentdata'=>$paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
