<?php

namespace App\Http\Controllers\PwdElectrical;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\ApprovalHierarchies;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\Pwd\DevelopmentWorkQuantityService;
use App\Models\PwdElectrical\DevelopmentWorksQuantity;
use App\Http\Requests\PwdElectrical\DevelopmentWorkQuantity\CreateRequest;
use App\Http\Requests\PwdElectrical\DevelopmentWorkQuantity\UpdateRequest;

class DevelopmentWorkQuantityController extends Controller
{
    protected $commonService;
    protected $developmentWorkQuantityService;

    public function __construct(CommonService $commonService, DevelopmentWorkQuantityService $developmentWorkQuantityService)
    {
        $this->commonService = $commonService;
        $this->developmentWorkQuantityService = $developmentWorkQuantityService;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('PwdElectrical.Development-Works-Quantity.create', compact('options', 'zones'));
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {

        $result = $this->developmentWorkQuantityService->store($request);

        if ($result[0]) {
            return response()->json([
                'success' => 'Application Submitted Successfully'
            ]);
        }

        return response()->json([
            'error' => $result[1]
        ]);
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {

        $id = decrypt($id);
        $developmentworkquantity = DevelopmentWorksQuantity::findOrFail($id);
        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();
        $status = Status::where('table_id', $id)
        ->where('service_id', $developmentworkquantity->service_id)
        ->first();

         $approvaldata = ApprovalHierarchies::where('service_id',$developmentworkquantity->service_id)->where('table_id',$id)->get();


        return view('PwdElectrical.Development-Works-Quantity.update', compact(
            'developmentworkquantity',
            'options',
            'zones',
            'status',
            'approvaldata'
        ));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
        $updated = $this->developmentWorkQuantityService->update($request, $id);

        if ($updated[0]) {
            return response()->json(['success' => 'Development work quantity-wise report updated successfully.']);
        }

        return response()->json(['error' => $updated[1]]);
    }

    /**
     * Display the specified resource as PDF.
     */
    public function show($id)
    {
        $data = DevelopmentWorksQuantity::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('PwdElectrical.Development-Works-Quantity.developmentworkquantitycertificate', compact('data'));

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = DevelopmentWorksQuantity::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('PwdElectrical.Development-Works-Quantity.receipt', ['data' => $data , 'paymentdata'=>$paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
