<?php

namespace App\Http\Controllers\PwdElectrical;

use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\Pwd\PathRoadCitizienshipService;
use App\Models\PwdElectrical\PathRoadCitizenshipCertificate;
use App\Http\Requests\PwdElectrical\PathRoadCitizen\CreateRequest;
use App\Http\Requests\PwdElectrical\PathRoadCitizen\UpdateRequest;


class PathRoadCitizienshipController extends Controller
{

        protected $commonService;
        protected $pathroadcitizen;

       public function __construct(PathRoadCitizienshipService $pathroadcitizen, CommonService $commonService)
       {
        $this->pathroadcitizen = $pathroadcitizen;
        $this->commonService = $commonService;
       }



    // public function index()
    // {
    //     //
    // }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('PwdElectrical.Path-Road-Citizen.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        // dd($request->all());
        $pathroadcitizen = $this->pathroadcitizen->store($request);
        // dd()
        if ($pathroadcitizen[0]) {
            return response()->json([
                'success' => 'Application Submitted Successfully'
            ]);
        } else {
            return response()->json([
                'error' => $pathroadcitizen[1]
            ]);
        }
    }

    /**
     * Display the specified resource.
     */
    // public function show(string $id)
    // {
    //     //
    // }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {
        $pathroadcitizen = $this->pathroadcitizen->edit(decrypt($id));
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('PwdElectrical.Path-Road-Citizen.update')->with([
            'pathroadcitizen' => $pathroadcitizen,
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
        $updated = $this->pathroadcitizen->update($request, $id);

        if ($updated[0]) {
            return response()->json(['success' => 'Path Road Citizen updated successfully!']);
        } else {
            return response()->json(['error' => $updated[1]]);
        }
    }

    /**
     * Remove the specified resource from storage.
     */

     public function show($id)
     {

        $data = PathRoadCitizenshipCertificate::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('PwdElectrical.Path-Road-Citizen.pathroadcitizencertificate', ['data' => $data , 'paymentdata'=> $paymentdata]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }
    // public function destroy(string $id)
    // {
    //     //
    // }
}
