<?php

namespace App\Http\Controllers\PwdElectrical;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\ApprovalHierarchies;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\Pwd\PrivateInfrastructureService;
use App\Models\PwdElectrical\PrivateInfrastructureWorkPermission;
use App\Http\Requests\PwdElectrical\PrivateInfrastructure\CreateRequest;
use App\Http\Requests\PwdElectrical\PrivateInfrastructure\UpdateRequest;

class PrivateInfrastructureController extends Controller
{
    protected $commonService;
    protected $privateInfrastructureService;

    public function __construct(PrivateInfrastructureService $privateInfrastructureService, CommonService $commonService)
    {
        $this->privateInfrastructureService = $privateInfrastructureService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('PwdElectrical.Private-Infrastructure-Work.create', compact('wards', 'zones'));
    }

    public function store(CreateRequest $request)
    {
        $result = $this->privateInfrastructureService->store($request);

        return response()->json([
            $result[0] ? 'success' : 'error' => $result[0]
                ? 'Application Submitted Successfully'
                : $result[1]
        ]);
    }

    public function edit($id)
    {
        $id = decrypt($id);
        $privateinfrastructure = PrivateInfrastructureWorkPermission::findOrFail($id);
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();
         $status = Status::where('table_id', $id)
        ->where('service_id', $privateinfrastructure->service_id)
        ->first();

    $approvaldata = ApprovalHierarchies::where('service_id',$privateinfrastructure->service_id)->where('table_id',$id)->get();


        return view('PwdElectrical.Private-Infrastructure-Work.update', compact('privateinfrastructure', 'wards', 'zones','status','approvaldata'));
    }

    public function update(UpdateRequest $request, $id)
    {
        $result = $this->privateInfrastructureService->update($request, $id);

        return response()->json([
            $result[0] ? 'success' : 'error' => $result[0]
                ? 'Private Infrastructure Work Permission updated successfully.'
                : $result[1]
        ]);
    }

    public function show($id)
    {
        $data = PrivateInfrastructureWorkPermission::with('user')->findOrFail(decrypt($id));
        $data_payment= decrypt($id);

        $payment = \App\Models\SbiPayment::where('service_id', $data->service_id)
        ->where('table_id', $data_payment)
        ->first();

        $pdf = SnappyPdf::loadView('PwdElectrical.Private-Infrastructure-Work.privateinfrastructureworkcertificate', compact('data','payment'))
            ->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('no-stop-slow-scripts', true)
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = PrivateInfrastructureWorkPermission::with('user')->findOrFail(decrypt($id));

        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();

        $pdf = SnappyPdf::loadView('PwdElectrical.Private-Infrastructure-Work.receipt', ['data' => $data,
    'paymentdata' => $paymentdata ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
