<?php

namespace App\Http\Controllers\PwdElectrical;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\ApprovalHierarchies;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\PwdElectrical\SarvajanikService;
use App\Http\Requests\PwdElectrical\SarvjanikJagetun\CreateRequest;
use App\Http\Requests\PwdElectrical\SarvjanikJagetun\UpdateRequest;
use App\Models\PwdElectrical\SarvajanikJagetunJanaraRastyachaDakhla;



class SarvajanikJagetunController extends Controller
{
    protected $commonService;
    protected $sarvajanikService;

    public function __construct(SarvajanikService $sarvajanikService, CommonService $commonService)
    {
        $this->sarvajanikService = $sarvajanikService;
        $this->commonService = $commonService;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('PwdElectrical.sarvajnik-jagetun.create')->with([
            'options' => $options,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        // dd($request->all());
        $sarvajanikdakhala = $this->sarvajanikService->store($request);

        if ($sarvajanikdakhala[0]) {
            return response()->json([
                'success' => 'Application Submitted Successfully'
            ]);
        } else {
            return response()->json([
                'error' => $sarvajanikdakhala[1]
            ]);
        }
    }



    public function edit($id)
    {
        $id = decrypt($id);
        $sarvajanikdakhala = SarvajanikJagetunJanaraRastyachaDakhla::findOrFail($id);

        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();
        $status = Status::where('table_id', $id)
        ->where('service_id', $sarvajanikdakhala->service_id)
        ->first();

    $approvaldata = ApprovalHierarchies::where('service_id',$sarvajanikdakhala->service_id)->where('table_id',$id)->get();


        return view('PwdElectrical.sarvajnik-jagetun.update')->with([
            'sarvajanikdakhala' => $sarvajanikdakhala,
            'options' => $options,
            'zones' => $zones,
            'status'  => $status,
            'approvaldata' => $approvaldata
        ]);
    }


    public function update(UpdateRequest $request, $id)
    {
        $updated = $this->sarvajanikService->update($request, $id);


        if ($updated[0]) {
            return response()->json(['success' => 'Sarvajanik dakhla updated successfully!']);
        } else {
            return response()->json(['error' => $updated[1]]);
        }
    }

    public function show($id)
    {

        $data = SarvajanikJagetunJanaraRastyachaDakhla::with('user')->findOrFail(decrypt($id));
        $pdf = SnappyPdf::loadView('PwdElectrical.sarvajnik-jagetun.sarvajanikcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = SarvajanikJagetunJanaraRastyachaDakhla::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();

        $pdf = SnappyPdf::loadView('PwdElectrical.sarvajnik-jagetun.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }





    /**
     * Store a newly created resource in storage.
     */


    /**
     * Show the form for editing the specified resource.
     */


    /**
     * Update the specified resource in storage.
     */
}
