<?php

namespace App\Http\Controllers\PwdElectrical;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\ApprovalHierarchies;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PwdElectrical\StromWaterDrain;
use App\Services\Pwd\StromWaterDrainsService;
use App\Http\Requests\PwdElectrical\StromWaterDrain\CreateRequest;
use App\Http\Requests\PwdElectrical\StromWaterDrain\UpdateRequest;

class StromWaterDrainsController extends Controller
{
    protected $commonService;
    protected $stromwaterdrains;

    public function __construct(StromWaterDrainsService $stromwaterdrains, CommonService $commonService)
    {
        $this->stromwaterdrains = $stromwaterdrains;
        $this->commonService = $commonService;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('PwdElectrical.strom-water-drains.create')->with([
            'options' => $options,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        // dd($request->all());
        $stromwaterdrain = $this->stromwaterdrains->store($request);
        // dd()
        if ($stromwaterdrain[0]) {
            return response()->json([
                'success' => 'Application Submitted Successfully'
            ]);
        } else {
            return response()->json([
                'error' => $stromwaterdrain[1]
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {

        $id = decrypt($id);
        $stromwaterdrains = StromWaterDrain::findOrFail($id);

        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();
        $status = Status::where('table_id', $id)
        ->where('service_id', $stromwaterdrains->service_id)
        ->first();

        $approvaldata = ApprovalHierarchies::where('service_id',$stromwaterdrains->service_id)->where('table_id',$id)->get();


        return view('PwdElectrical.strom-water-drains.update')->with([
            'stromwaterdrains' => $stromwaterdrains,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
            'approvaldata' => $approvaldata
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
        $updated = $this->stromwaterdrains->update($request, $id);

        if ($updated[0]) {
            return response()->json(['success' => 'Strom Water Drain updated successfully!']);
        } else {
            return response()->json(['error' => $updated[1]]);
        }
    }

    public function show($id)
    {

        $data = StromWaterDrain::with('user')->findOrFail(decrypt($id));
        $pdf = SnappyPdf::loadView('PwdElectrical.strom-water-drains.stromcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

       public function generateReceipt($id)
    {
        $data = StromWaterDrain::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('PwdElectrical.strom-water-drains.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
