<?php

namespace App\Http\Controllers\PwdElectrical;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\ApprovalHierarchies;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PwdElectrical\VibhagakadeThakbakiNaslyachePramanpatra;
use App\Services\PwdElectrical\VibhagThakbakiNaslyachePramanpatraService;
use App\Http\Requests\PwdElectrical\VibhagThakbakiNaslyachePramanpatra\CreateRequest;
use App\Http\Requests\PwdElectrical\VibhagThakbakiNaslyachePramanpatra\UpdateRequest;



class VibhagThakbakiNaslyachePramanpatraController extends Controller
{
    protected $commonService;
    protected $vibhagThakbakiNaslyachePramanpatraService;

    public function __construct(VibhagThakbakiNaslyachePramanpatraService $vibhagThakbakiNaslyachePramanpatraService, CommonService $commonService)
    {
        $this->vibhagThakbakiNaslyachePramanpatraService = $vibhagThakbakiNaslyachePramanpatraService;
        $this->commonService = $commonService;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('PwdElectrical.vibhag-thakbaki.create')->with([
            'options' => $options,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $vibhagThakbakiNaslyachePramanpatra = $this->vibhagThakbakiNaslyachePramanpatraService->store($request);
        if ($vibhagThakbakiNaslyachePramanpatra[0]) {
            return response()->json([
                'success' => 'Application Submitted Successfully'
            ]);
        } else {
            return response()->json([
                'error' => $vibhagThakbakiNaslyachePramanpatra[1]
            ]);
        }
    }



    public function edit($id)

    {

        $id = decrypt($id);
        $vibhagThakbakiNaslyachePramanpatra = VibhagakadeThakbakiNaslyachePramanpatra::findOrFail($id);

        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        $status = Status::where('table_id', $id)
            ->where('service_id', $vibhagThakbakiNaslyachePramanpatra->service_id)
            ->first();

        $approvaldata = ApprovalHierarchies::where('service_id',$vibhagThakbakiNaslyachePramanpatra->service_id)->where('table_id',$id)->get();


        return view('PwdElectrical.vibhag-thakbaki.update')->with([
            'vibhagThakbakiNaslyachePramanpatra' =>  $vibhagThakbakiNaslyachePramanpatra,
            'options' => $options,
            'status'  =>  $status,
            'zones' => $zones,
            'approvaldata' => $approvaldata
        ]);
    }


    public function update(UpdateRequest $request, $id)
    {
        $updated = $this->vibhagThakbakiNaslyachePramanpatraService->update($request, $id);
        // dd($updated);

        if ($updated[0]) {
            return response()->json(['success' => 'Vikas thankbaki naslyache updated successfully!']);
        } else {
            return response()->json(['error' => $updated[1]]);
        }
    }

    public function show($id)
    {

        $data = VibhagakadeThakbakiNaslyachePramanpatra::with('user')->findOrFail(decrypt($id));
        $pdf = SnappyPdf::loadView('PwdElectrical.vikas-kamacha-gopniy-dakhla.vikascertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }


    public function generateReceipt($id)
    {
        $data = VibhagakadeThakbakiNaslyachePramanpatra::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();

        $pdf = SnappyPdf::loadView('PwdElectrical.vikas-kamacha-gopniy-dakhla.receipt', ['data' => $data , 'paymentdata'=> $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }


    /**
     * Store a newly created resource in storage.
     */


    /**
     * Show the form for editing the specified resource.
     */


    /**
     * Update the specified resource in storage.
     */
}
