<?php

namespace App\Http\Controllers\PwdElectrical;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\ApprovalHierarchies;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PwdElectrical\VikasKamachGopniyDakhla;
use App\Services\PwdElectrical\VikasKamachaGopniyDakhlaService;
use App\Http\Requests\PwdElectrical\VikasKamachaDakhla\CreateRequest;
use App\Http\Requests\PwdElectrical\VikasKamachaDakhla\UpdateRequest;



class VikasKamachaGopniyDakhlaController extends Controller
{
    protected $commonService;
    protected $vikaskamachagopniydakhlaService;

    public function __construct(VikasKamachaGopniyDakhlaService $vikaskamachagopniydakhlaService, CommonService $commonService)
    {
        $this->vikaskamachagopniydakhlaService = $vikaskamachagopniydakhlaService;
        $this->commonService = $commonService;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('PwdElectrical.vikas-kamacha-gopniy-dakhla.create')->with([
            'options' => $options,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        // dd($request->all());
        $vikaskamachagopniydakhala = $this->vikaskamachagopniydakhlaService->store($request);
        // dd()
        if ($vikaskamachagopniydakhala[0]) {
            return response()->json([
                'success' => 'Application Submitted Successfully'
            ]);
        } else {
            return response()->json([
                'error' => $vikaskamachagopniydakhala[1]
            ]);
        }
    }



    public function edit($id)
    {

        $id = decrypt($id);
        $vikaskamachagopniydakhala = VikasKamachGopniyDakhla::findOrFail($id);

        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        $status = Status::where('table_id', $id)
        ->where('service_id', $vikaskamachagopniydakhala->service_id)
        ->first();

                $approvaldata = ApprovalHierarchies::where('service_id',$vikaskamachagopniydakhala->service_id)->where('table_id',$id)->get();


        return view('PwdElectrical.vikas-kamacha-gopniy-dakhla.update')->with([
            'vikaskamachagopniydakhala' => $vikaskamachagopniydakhala,
            'options' => $options,
            'zones' => $zones,
            'status' =>  $status,
            'approvaldata' => $approvaldata
        ]);
    }


    public function update(UpdateRequest $request, $id)
    {
        $updated = $this->vikaskamachagopniydakhlaService->update($request, $id);
        // dd($updated);

        if ($updated[0]) {
            return response()->json(['success' => 'Vikas kamacha gopniy dakhla updated successfully!']);
        } else {
            return response()->json(['error' => $updated[1]]);
        }
    }

    public function show($id)
    {

        $data = VikasKamachGopniyDakhla::with('user')->findOrFail(decrypt($id));
        $pdf = SnappyPdf::loadView('PwdElectrical.vikas-kamacha-gopniy-dakhla.vikascertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = VikasKamachGopniyDakhla::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();

        $pdf = SnappyPdf::loadView('PwdElectrical.vikas-kamacha-gopniy-dakhla.receipt', ['data' => $data ,
     'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }





    /**
     * Store a newly created resource in storage.
     */


    /**
     * Show the form for editing the specified resource.
     */


    /**
     * Update the specified resource in storage.
     */
}
