<?php

namespace App\Http\Controllers\PwdElectrical;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\ApprovalHierarchies;
use App\Http\Controllers\Controller;
use App\Services\Pwd\WindBlowService;
use App\Models\PwdElectrical\WindBlow;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Http\Requests\PwdElectrical\WindBlow\CreateRequest;
use App\Http\Requests\PwdElectrical\WindBlow\UpdateRequest;

class WindBlowController extends Controller
{
    protected $commonService;
    protected $windblow;

    public function __construct(WindBlowService $windblow, CommonService $commonService)
    {
        $this->windblow = $windblow;
        $this->commonService = $commonService;
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {

        $options = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('PwdElectrical.Windblow.create')->with([
            'options' => $options,
            'zones' => $zones,
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(CreateRequest $request)
    {
        // dd($request->all());
        $stromwaterdrain = $this->windblow->store($request);
        // dd()
        if ($stromwaterdrain[0]) {
            return response()->json([
                'success' => 'Application Submitted Successfully'
            ]);
        } else {
            return response()->json([
                'error' => $stromwaterdrain[1]
            ]);
        }
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit($id)
    {

        $id = decrypt($id);
        $data = WindBlow::findOrFail($id);
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();
        $status = Status::where('table_id', $id)
        ->where('service_id', $data->service_id)
        ->first();

    $approvaldata = ApprovalHierarchies::where('service_id',$data->service_id)->where('table_id',$id)->get();


        return view('PwdElectrical.Windblow.update')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
            'approvaldata' => $approvaldata
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(UpdateRequest $request, $id)
    {
        $updated = $this->windblow->update($request, $id);

        if ($updated[0]) {
            return response()->json(['success' => 'Wind Blow Drain updated successfully!']);
        } else {
            return response()->json(['error' => $updated[1]]);
        }
    }

    public function show($id)
    {

        $data = WindBlow::with('user')->findOrFail(decrypt($id));
        $pdf = SnappyPdf::loadView('PwdElectrical.Windblow.stromcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

       public function generateReceipt($id)
    {
        $data = WindBlow::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('PwdElectrical.Windblow.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
