<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use App\Models\SmsDeliveryReport;

class SmsDeliveryController extends Controller
{
    public function receive(Request $request)
    {
        // Log full callback for troubleshooting
        Log::info('SMS delivery callback received', [
            'payload' => $request->all(),
            'headers' => $request->headers->all(),
        ]);

        // Persist the delivery report if DB is available
        try {
            SmsDeliveryReport::create([
                'payload' => json_encode($request->all()),
                'headers' => json_encode($request->headers->all()),
            ]);
        } catch (\Exception $e) {
            Log::error('Failed to persist SMS delivery report: ' . $e->getMessage());
        }

        return response()->json(['status' => 'ok']);
    }
}
