<?php
namespace App\Http\Controllers\TaxProperty;
use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PropertyTax\PropertyTaxAssessment;
use App\Services\PropertyTax\PropertyTaxAssessmentService;
use App\Http\Requests\PropertyTax\PropertyTaxAssessmentRequest;


class IssuanceController extends Controller
{
    protected $propertyTaxAssessmentService;
    protected $commonService;

    public function __construct(PropertyTaxAssessmentService $propertyTaxAssessmentService, CommonService $commonService)
    {
        $this->propertyTaxAssessmentService = $propertyTaxAssessmentService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $user = Auth::user();

        return view('property-tax.issuanceOfPropertyTax.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user
        ]);
    }

    public function store(PropertyTaxAssessmentRequest $request)
    {
        $propertyTaxAssessment = $this->propertyTaxAssessmentService->store($request);

        if ($propertyTaxAssessment[0]) {
            return response()->json([
                'success' => 'Property tax assessment created successfully'
            ]);
        } else {
            return response()->json([
                'error' => $propertyTaxAssessment[1]
            ]);
        }
    }

    public function edit(string $id)
    {

        $id = decrypt($id);
        $propertyTaxAssessment = PropertyTaxAssessment::findOrFail($id);

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        $status = Status::where('table_id', $id)
            ->where('service_id', $propertyTaxAssessment->service_id)
            ->first();

        return view('property-tax.issuanceOfPropertyTax.edit')->with([
            'propertyTaxAssessment' => $propertyTaxAssessment,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }


    public function update(PropertyTaxAssessmentRequest $request, string $id)
    {
        $propertyTaxAssessment = $this->propertyTaxAssessmentService->update($request);

        if ($propertyTaxAssessment[0]) {
            return response()->json([
                'success' => 'Property tax assessment updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $propertyTaxAssessment[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = PropertyTaxAssessment::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('property-tax.issuanceOfPropertyTax.issuanceofpropertycertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
            // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = PropertyTaxAssessment::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id', $data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('hoarding-permission.receipt', ['data' => $data, 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
            // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
