<?php

namespace App\Http\Controllers\TaxProperty;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PropertyTax\Newtaxation;
use App\Services\PropertyTax\NewtaxationService;
use App\Http\Requests\PropertyTax\NewTaxationRequest;



class NewTaxationController extends Controller
{
    protected $newtaxationService;
    protected $commonService;

    public function __construct(NewtaxationService $newtaxationService, CommonService $commonService)
    {
        $this->newtaxationService = $newtaxationService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('property-tax.newTaxation.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }


    public function store(NewTaxationRequest $request)
    {
        $newTax = $this->newtaxationService->store($request);

        if ($newTax[0]) {
            return response()->json([
                'success' => 'New tax created successfully'
            ]);
        } else {
            return response()->json([
                'error' => $newTax[1]
            ]);
        }
    }

    public function edit(string $id)
    {

         $id = decrypt($id);
        $newTax = Newtaxation::findOrFail($id);

        $status = Status::where('table_id', $id)
        ->where('service_id', $newTax->service_id)
        ->first();


        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('property-tax.newTaxation.edit')->with([
            'newTax' => $newTax,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }


    public function update(NewTaxationRequest $request, string $id)
    {
        $newTax = $this->newtaxationService->update($request);

        if ($newTax[0]) {
            return response()->json([
                'success' => 'New tax update successfully'
            ]);
        } else {
            return response()->json([
                'error' => $newTax[1]
            ]);
        }
    }

     public function show($id)
    {
        $data = Newtaxation::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('property-tax.newTaxation.newtaxationcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = Newtaxation::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('property-tax.newTaxation.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
