<?php

namespace App\Http\Controllers\TaxProperty;

use App\Models\User;
use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PropertyTax\NoDueCertificate;
use App\Services\PropertyTax\NoDueCertificateService;
use App\Http\Requests\PropertyTax\NoDueCertificateRequest;

class NoDueController extends Controller
{
    protected $noDueCertificateService;
    protected $commonService;

    public function __construct(NoDueCertificateService $noDueCertificateService, CommonService $commonService)
    {
        $this->noDueCertificateService = $noDueCertificateService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        $user = Auth::user();

        return view('property-tax.noDues.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user
        ]);
    }

    public function store(NoDueCertificateRequest $request)
    {
        $noDue = $this->noDueCertificateService->store($request);

        if ($noDue[0]) {
            return response()->json([
                'success' => 'No due certificate created successfully'
            ]);
        } else {
            return response()->json([
                'error' => $noDue[1]
            ]);
        }
    }

    public function fetchpropertyDetails(Request $request)
    {
        $request->validate([
            'marchantid' => 'required|string',
            'propno' => 'required|string',
        ]);

        $waterdata = [
            "jsonData" => [
                [
                    "MerchantID" => $request->marchantid,
                    "propno" => $request->propno,
                    "flatno" => ""
                ]
            ]
        ];

        $jsonData = json_encode($waterdata);


        $encryptedData = $this->commonService->encryptString($jsonData);
        $apidata = $this->commonService->sendEncryptedData($encryptedData);

        return response()->json([

            'jsonData' => [
                'encr_request' => $apidata,
            ]
        ]);
    }


    // NO Due
    public function fetchnoDuespropertyDetails(Request $request)
    {
        $request->validate([
            'marchantid' => 'required|string',
            'propno' => 'required|string',
        ]);

        $waterdata = [
            "jsonData" => [
                [
                    "MerchantID" => $request->marchantid,
                    "propno" => $request->propno,
                    "flatno" => ""
                ]
            ]
        ];

        $jsonData = json_encode($waterdata);


        $encryptedData = $this->commonService->encryptString($jsonData);
        $apidata = $this->commonService->sendNODueEncryptedData($encryptedData);

        return response()->json([

            'jsonData' => [
                'encr_request' => $apidata,
            ]
        ]);
    }

    public function storepropertyDetails(Request $request)
    {
        $inputData = $request->all();
        $jsonData = json_encode($inputData);
        $encryptedData = $this->commonService->encryptString($jsonData);
        $decryptedResponse = $this->commonService->propertyDataStrore($encryptedData);
        return response()->json([
            'response' => $decryptedResponse
        ]);
    }


    public function edit(string $id)
    {

         $id = decrypt($id);
        $noDue = NoDueCertificate::findOrFail($id);

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

          $status = Status::where('table_id', $id)
        ->where('service_id', $noDue->service_id)
        ->first();


        return view('property-tax.noDues.edit')->with([
            'noDue' => $noDue,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    public function update(NoDueCertificateRequest $request, string $id)
    {
        $noDue = $this->noDueCertificateService->update($request);

        if ($noDue[0]) {
            return response()->json([
                'success' => 'No due certificate updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $noDue[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = NoDueCertificate::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('property-tax.noDues.noduescertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = NoDueCertificate::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('property-tax.noDues.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
