<?php

namespace App\Http\Controllers\TaxProperty;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Http\Requests\PropertyTax\PropertyDivision;
use App\Models\Trade\PropertyDivisionIntoSubDivision;
use App\Services\Trade\ChangePropertyDivisionService;


class PropertyDivisionIntoSubDivisionController extends Controller
{
    protected $propertydivision;
    protected $commonService;

    public function __construct(ChangePropertyDivisionService $propertydivision, CommonService $commonService)
    {
        $this->propertydivision = $propertydivision;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
         $user = Auth::user();

        return view('property-tax.propertyDivision.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user
        ]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(PropertyDivision $request)
    {
        $propertydivision = $this->propertydivision->store($request);

        if ($propertydivision[0]) {
            return response()->json([
                'success' => 'Property Division assessment created successfully'
            ], 200);
        } else {
            return response()->json([
                'error' => $propertydivision[1]
            ], 422);
        }
    }


    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        $id = decrypt($id);

        $propertydivision = PropertyDivisionIntoSubDivision::findOrFail($id);

        $status = Status::where('table_id', $id)
            ->where('service_id', $propertydivision->service_id)
            ->first();

        $wards = $this->commonService->getActiveWard();

        // $zones = $this->commonService->getActiveZone();

        return view('property-tax.propertyDivision.edit')->with([
            'propertydivision' => $propertydivision,
            'wards' => $wards,
            // 'zones' => $zones,
            'status' => $status
        ]);
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }

    public function show($id)
    {
        $data = PropertyDivisionIntoSubDivision::findOrFail(decrypt($id));
        $pdf = SnappyPdf::loadView('property-tax.propertyDivision.propertydivisioncertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = PropertyDivisionIntoSubDivision::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('property-tax.propertyDivision.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);
        // dd($data);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
