<?php

namespace App\Http\Controllers\TaxProperty;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PropertyTax\RegistrationOfObjection;
use App\Services\PropertyTax\RegistrationOfObjectionService;
use App\Http\Requests\PropertyTax\RegistrationOfObjectionRequest;


class RegistrationOfObjectionController extends Controller
{
    protected $registrationOfObjectionService;
    protected $commonService;

    public function __construct(RegistrationOfObjectionService $registrationOfObjectionService, CommonService $commonService)
    {
        $this->registrationOfObjectionService = $registrationOfObjectionService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $user = Auth::user();

        return view('property-tax.RegistrationOfObjection.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user
        ]);
    }

    public function store(RegistrationOfObjectionRequest $request)
    {
        $registrationofObjection = $this->registrationOfObjectionService->store($request);

        if ($registrationofObjection[0]) {
            return response()->json([
                'success' => 'Registration of objection created successfully'
            ]);
        } else {
            return response()->json([
                'error' => $registrationofObjection[1]
            ]);
        }
    }




    public function edit(string $id)
    {
        $id = decrypt($id);
        $registrationofObjection = registrationofObjection::findOrFail($id);

        $status = Status::where('table_id', $id)
        ->where('service_id', $registrationofObjection->service_id)
        ->first();
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();


        return view('property-tax.RegistrationOfObjection.edit')->with([
            'registrationofObjection' => $registrationofObjection,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    public function update(RegistrationOfObjectionRequest $request, string $id)
    {
        $registrationofObjection = $this->registrationOfObjectionService->update($request);

        if ($registrationofObjection[0]) {
            return response()->json([
                'success' => 'Registration of objection updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $registrationofObjection[1]
            ]);
        }
    }

     public function show($id)
    {
        $data = RegistrationOfObjection::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('property-tax.RegistrationOfObjection.registrationcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = RegistrationOfObjection::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('property-tax.noDues.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
