<?php

namespace App\Http\Controllers\TaxProperty;
use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\PropertyTax\ReTaxation;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\PropertyTax\ReTaxationService;
use App\Http\Requests\PropertyTax\RetaxationRequest;


class RetaxationController extends Controller
{
    protected $reTaxationService;
    protected $commonService;

    public function __construct(ReTaxationService $reTaxationService, CommonService $commonService)
    {
        $this->reTaxationService = $reTaxationService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        $user = Auth::user();

        return view('property-tax.reTaxation.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user
        ]);
    }

    public function store(RetaxationRequest $request)
    {
        $retax = $this->reTaxationService->store($request);

        if ($retax[0]) {
            return response()->json([
                'success' => 'Re taxation created successfully'
            ]);
        } else {
            return response()->json([
                'error' => $retax[1]
            ]);
        }
    }

    public function edit(string $id)
    {

         $id = decrypt($id);
        $retax = ReTaxation::findOrFail($id);

        $status = Status::where('table_id', $id)
        ->where('service_id', $retax->service_id)
        ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('property-tax.reTaxation.edit')->with([
            'retax' => $retax,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    public function update(RetaxationRequest $request, string $id)
    {
        $retax = $this->reTaxationService->update($request);

        if ($retax[0]) {
            return response()->json([
                'success' => 'Re taxation updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $retax[1]
            ]);
        }
    }

     public function show($id)
    {
        $data = ReTaxation::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('property-tax.reTaxation.retaxationcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = ReTaxation::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('property-tax.reTaxation.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
