<?php

namespace App\Http\Controllers\TaxProperty;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PropertyTax\SelfAssessment;
use App\Services\PropertyTax\SelfAssessmentService;
use App\Http\Requests\PropertyTax\SelfAssessmentRequest;


class SelfAssessmentController extends Controller
{
    protected $selfAssessmentService;
    protected $commonService;

    public function __construct(SelfAssessmentService $selfAssessmentService, CommonService $commonService)
    {
        $this->selfAssessmentService = $selfAssessmentService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        $user = Auth::user();

        return view('property-tax.selfAssessment.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user
        ]);
    }

    public function store(SelfAssessmentRequest $request)
    {
        $selfAssessment = $this->selfAssessmentService->store($request);

        if ($selfAssessment[0]) {
            return response()->json([
                'success' => 'Self assessment created successfully'
            ]);
        } else {
            return response()->json([
                'error' => $selfAssessment[1]
            ]);
        }
    }

    public function edit($id)
    {

        $id = decrypt($id);
        $selfAssessment = SelfAssessment::findOrFail($id);

        $status = Status::where('table_id', $id)
        ->where('service_id', $selfAssessment->service_id)
        ->first();


        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('property-tax.selfAssessment.edit')->with([
            'selfAssessment' => $selfAssessment,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    public function update(SelfAssessmentRequest $request, string $id)
    {
        $selfAssessment = $this->selfAssessmentService->update($request);

        if ($selfAssessment[0]) {
            return response()->json([
                'success' => 'Self assessment updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $selfAssessment[1]
            ]);
        }
    }

     public function show($id)
    {
        $data = SelfAssessment::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('property-tax.selfAssessment.selfCertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = SelfAssessment::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('property-tax.selfAssessment.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
