<?php

namespace App\Http\Controllers\TaxProperty;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use App\Models\PropertyTax\TaxDemand;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\PropertyTax\TaxDemandService;
use App\Http\Requests\PropertyTax\TaxDemandRequest;

class TaxDemandController extends Controller
{
    protected $taxDemandService;
    protected $commonService;

    public function __construct(TaxDemandService $taxDemandService, CommonService $commonService)
    {
        $this->taxDemandService = $taxDemandService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();
       $user = Auth::user();
        $zones = $this->commonService->getActiveZone();

        return view('property-tax.taxDemand.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' => $user
        ]);
    }

    public function store(TaxDemandRequest $request)
    {
        $taxDemand = $this->taxDemandService->store($request);

        if ($taxDemand[0]) {
            return response()->json([
                'success' => 'Tax demand created successfully'
            ]);
        } else {
            return response()->json([
                'error' => $taxDemand[1]
            ]);
        }
    }

    public function edit(string $id)
    {
        $id = decrypt($id);
        $taxDemand = TaxDemand::findOrFail($id);

        $status = Status::where('table_id', $id)
        ->where('service_id', $taxDemand->service_id)
        ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('property-tax.taxDemand.edit')->with([
            'taxDemand' => $taxDemand,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    public function update(TaxDemandRequest $request, string $id)
    {
        $taxDemand = $this->taxDemandService->update($request);

        if ($taxDemand[0]) {
            return response()->json([
                'success' => 'Tax demand updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $taxDemand[1]
            ]);
        }
    }

     public function show($id)
    {
        $data = TaxDemand::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('property-tax.taxDemand.taxdemandcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = TaxDemand::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('property-tax.taxDemand.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
