<?php

namespace App\Http\Controllers\TaxProperty;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PropertyTax\TaxExemption;
use App\Services\PropertyTax\TaxExemptionService;
use App\Http\Requests\PropertyTax\TaxExemptionRequest;


class TaxExemptionController extends Controller
{
    protected $taxExemptionService;
    protected $commonService;

    public function __construct(TaxExemptionService $taxExemptionService, CommonService $commonService)
    {
        $this->taxExemptionService = $taxExemptionService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        $user =Auth::user();

        return view('property-tax.taxExemption.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user' =>   $user
        ]);
    }

    public function store(TaxExemptionRequest $request)
    {
        $taxExemption = $this->taxExemptionService->store($request);

        if ($taxExemption[0]) {
            return response()->json([
                'success' => 'Tax exemption created successfully'
            ]);
        } else {
            return response()->json([
                'error' => $taxExemption[1]
            ]);
        }
    }

    public function edit(string $id)
    {

        $id = decrypt($id);
        $taxExemption = TaxExemption::findOrFail($id);

        $status = Status::where('table_id', $id)
        ->where('service_id', $taxExemption->service_id)
        ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('property-tax.taxExemption.edit')->with([
            'taxExemption' => $taxExemption,
            'wards' => $wards,
            'zones' => $zones,
            'status' =>$status
        ]);
    }

    public function update(TaxExemptionRequest $request, string $id)
    {
        $taxExemption = $this->taxExemptionService->update($request);

        if ($taxExemption[0]) {
            return response()->json([
                'success' => 'Tax exemption updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $taxExemption[1]
            ]);
        }
    }
    public function show($id)
    {
        $data = TaxExemption::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('property-tax.taxExemption.taxexemptioncertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = TaxExemption::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('hoarding-permission.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
