<?php

namespace App\Http\Controllers\TaxProperty;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PropertyTax\TaxExemptionNonResidentProperties;
use App\Services\PropertyTax\TaxExemptionNonResidentPropertiesService;
use App\Http\Requests\PropertyTax\TaxExemptionNonResidentPropertiesRequest;




class TaxExemptionNonResidentController extends Controller
{
    protected $taxExemptionNonResidentPropertiesService;
    protected $commonService;

    public function __construct(TaxExemptionNonResidentPropertiesService $taxExemptionNonResidentPropertiesService, CommonService $commonService)
    {
        $this->taxExemptionNonResidentPropertiesService = $taxExemptionNonResidentPropertiesService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        $user =Auth::user();

        return view('property-tax.taxExemptionNonResident.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user'  =>  $user
        ]);
    }

    public function store(TaxExemptionNonResidentPropertiesRequest $request)
    {
        $taxExemptionNonResidentialProp = $this->taxExemptionNonResidentPropertiesService->store($request);

        if ($taxExemptionNonResidentialProp[0]) {
            return response()->json([
                'success' => 'Tax exemption for non-residential application created successfully'
            ]);
        } else {
            return response()->json([
                'error' => $taxExemptionNonResidentialProp[1]
            ]);
        }
    }

    public function edit(string $id)
    {
        $id = decrypt($id);
        $taxExemptionNonResidentialProp = TaxExemptionNonResidentProperties::findOrFail($id);

        $status = Status::where('table_id', $id)
        ->where('service_id', $taxExemptionNonResidentialProp->service_id)
        ->first();


        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('property-tax.taxExemptionNonResident.edit')->with([
            'taxExemptionNonResidentialProp' => $taxExemptionNonResidentialProp,
            'wards' => $wards,
            'zones' => $zones,
            'status' =>$status
        ]);
    }

    public function update(TaxExemptionNonResidentPropertiesRequest $request, string $id)
    {
        $taxExemptionNonResidentialProp = $this->taxExemptionNonResidentPropertiesService->update($request);

        if ($taxExemptionNonResidentialProp[0]) {
            return response()->json([
                'success' => 'Tax exemption non residential property updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $taxExemptionNonResidentialProp[1]
            ]);
        }
    }
     public function show($id)
    {
        $data = TaxExemptionNonResidentProperties::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('property-tax.taxExemptionNonResident.taxexemptionnoncertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = TaxExemptionNonResidentProperties::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('property-tax.taxExemptionNonResident.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
