<?php

namespace App\Http\Controllers\TaxProperty;

use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PropertyTax\TransferPropertyCertificate;
use App\Http\Requests\PropertyTax\PropertyTaxAssessmentRequest;
use App\Services\PropertyTax\TransferRegistrationCertificateService;

class TransferRegistrationCertificateController extends Controller
{
    protected $transferRegistrationCertificateService;
    protected $commonService;

    public function __construct(TransferRegistrationCertificateService $transferRegistrationCertificateService, CommonService $commonService)
    {
        $this->transferRegistrationCertificateService = $transferRegistrationCertificateService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('property-tax.transferRegistrationCertificate.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function store(PropertyTaxAssessmentRequest $request)
    {
        $transferRegistrationCertificate = $this->transferRegistrationCertificateService->store($request);

        if ($transferRegistrationCertificate[0]) {
            return response()->json([
                'success' => 'Property registration certificate created successfully'
            ]);
        } else {
            return response()->json([
                'error' => $transferRegistrationCertificate[1]
            ]);
        }
    }

    public function edit($id)
    {
        $transferRegistrationCertificate = $this->transferRegistrationCertificateService->edit(decrypt($id));

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('property-tax.transferRegistrationCertificate.edit')->with([
            'transferRegistrationCertificate' => $transferRegistrationCertificate,
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function update(PropertyTaxAssessmentRequest $request)
    {
        $transferRegistrationCertificate = $this->transferRegistrationCertificateService->update($request);

        if ($transferRegistrationCertificate[0]) {
            return response()->json([
                'success' => 'Property registration certificate updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $transferRegistrationCertificate[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = TransferPropertyCertificate::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('abattoir-license.certificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = TransferPropertyCertificate::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('abattoir-license.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
