<?php

namespace App\Http\Controllers\TaxProperty;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\PropertyTax\TransferSelfPropertyCertificate;
use App\Services\PropertyTax\TransferSelfPropertyCertificateService;
use App\Http\Requests\PropertyTax\TransferSelfPropertyCertificateRequest;
use Illuminate\Support\Facades\Log;

class TransferSelfPropertyController extends Controller
{
    protected $transferselfPropertyCertificateService;
    protected $commonService;

    public function __construct(TransferSelfPropertyCertificateService $transferselfPropertyCertificateService, CommonService $commonService)
    {
        $this->transferselfPropertyCertificateService = $transferselfPropertyCertificateService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();
        $user = Auth::user();
        return view('property-tax.transferOfselfProperty.create')->with([
            'wards' => $wards,
            'zones' => $zones,
            'user'  => $user
        ]);
    }

    public function store(TransferSelfPropertyCertificateRequest $request)
    {
        $transferProperty = $this->transferselfPropertyCertificateService->store($request);
        if ($transferProperty[0]) {
            return response()->json([
                'success' => 'Property transfer created successfully'
            ]);
        } else {
            return response()->json([
                'error' => $transferProperty[1]
            ]);
        }
    }

    public function edit($id)
    {
        $id = decrypt($id);

        $transferProperty = TransferSelfPropertyCertificate::findOrFail($id);
        $status = Status::where('table_id', $id)
            ->where('service_id', $transferProperty->service_id)
            ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('property-tax.transferOfselfProperty.edit')->with([
            'transferProperty' => $transferProperty,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    public function update(TransferSelfPropertyCertificateRequest $request, $id)
    {
        $transferProperty = $this->transferselfPropertyCertificateService->update($request);

        if ($transferProperty[0]) {
            return response()->json([
                'success' => 'Property transfer update successfully'
            ]);
        } else {
            return response()->json([
                'error' => $transferProperty[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = TransferSelfPropertyCertificate::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('property-tax.transferOfselfProperty.transferofselfcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = TransferSelfPropertyCertificate::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('property-tax.transferOfselfProperty.receipt', ['data' => $data , 'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
