<?php

namespace App\Http\Controllers\TownPlaning;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\CityStructure\PartZoneService;
use App\Models\CityStructure\CityStructurePartMap;
use App\Http\Requests\CityStructure\PartMap\CreateRequest;
use App\Http\Requests\CityStructure\PartMap\UpdateRequest;

class BhagNakashaController extends Controller
{
    protected $partZoneService;

    public function __construct(PartZoneService $partZoneService)
    {
        $this->partZoneService = $partZoneService;
    }

    public function create()
    {
        $maptype = DB::table('partmapstypes')->get();

        return view('town-planing.bhag-nakasha.create',compact('maptype'));
    }

    public function store(CreateRequest $request)
    {
        $partZoneService = $this->partZoneService->store($request);

        if ($partZoneService) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

    public function edit(string $id)
    {
        $id = decrypt($id);
        $data = CityStructurePartMap::findOrFail($id);
        $status = Status::where('table_id', $id)
        ->where('service_id', $data->service_id)
        ->first();

         $maptype = DB::table('partmapstypes')->get();

        return view('town-planing.bhag-nakasha.edit', compact('data','status','maptype'));
    }

    public function update(UpdateRequest $request, string $id)
    {
        $partZoneService = $this->partZoneService->update($request, $id);

        if ($partZoneService) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

     public function show($id)
    {
        $data = CityStructurePartMap::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('town-planing.bhag-nakasha.bhagnakashacertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = CityStructurePartMap::with('user')->findOrFail(decrypt($id));

        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();

        $pdf = SnappyPdf::loadView('town-planing.bhag-nakasha.receipt', ['data' => $data,
        'paymentdata' => $paymentdata
        ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
