<?php

namespace App\Http\Controllers\TownPlaning;

use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\TownPlanning\BuildingPermission;
use App\Services\TownPlanning\BuildingPermissionService;
use App\Http\Requests\TownPlanning\BuildingPermission\CreateRequest;
use App\Http\Requests\TownPlanning\BuildingPermission\UpdateRequest;

class BuildingPermissionController extends Controller
{
    protected $commonService;
    protected $buildingpermission;


    // Constructor for dependency injection
    public function __construct(BuildingPermissionService $buildingpermission, CommonService $commonService)
    {
        $this->buildingpermission = $buildingpermission;
        $this->commonService = $commonService;
    }

    // Display the create form
    public function create()
    {
        // Get active wards and zones from CommonService
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        // Return the create view with wards and zones data
        return view('town-planing.building-permission.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    // Store the newly created abattoir license
    public function store(CreateRequest $request)
    {

        // Call the store method in the service and get the response
        $buildingpermission = $this->buildingpermission->store($request);
        //  dd($request);

        // dd($request);
        // Check if the license was successfully saved
        if ($buildingpermission[0]) {
            return response()->json([
                'success' => 'Building Permission saved successfully'
            ]);
        } else {
            return response()->json([
                'error' => $buildingpermission[1]
            ]);
        }
    }



    public function edit($id)
    {
    //  return encrypt($id);
        $buildingpermission = $this->buildingpermission->edit(decrypt($id));

        // $advertisementPermission = AdvertisementPermission::find($id);

        //  //return $advertisementPermission;

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        // $data = AdvertisementPermission::findOrFail($id);

        return view('town-planing.building-permission.update')->with([
            'buildingpermission'=>  $buildingpermission,
            'wards' => $wards,
            'zones' => $zones,
            // 'data' => '$data',

            'buildingpermission' => $buildingpermission
        ]);
    }
    public function update(UpdateRequest $request, $id)
    {
        // dd($request->all());
        $buildingpermission = $this->buildingpermission->update($request, $id);

        if ($buildingpermission) {
            return response()->json([
                'success' => 'Building permission updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

    public function show($id)
    {
        $data = BuildingPermission::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('abattoir-license.certificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }
}

