<?php

namespace App\Http\Controllers\TownPlaning;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\CityStructure\ZoneCertificateService;
use App\Models\CityStructure\CityStructureZoneCertificate;
use App\Http\Requests\CityStructure\ZoneCertificate\CreateRequest;
use App\Http\Requests\CityStructure\ZoneCertificate\UpdateRequest;

class ZoneCertificateController extends Controller
{
    protected $zoneCertificateService;

    public function __construct(ZoneCertificateService $zoneCertificateService)
    {
        $this->zoneCertificateService = $zoneCertificateService;
    }

    public function create()
    {
        $maptype = DB::table('partmapstypes')->get();

        return view('town-planing.zone-certificate.create',compact('maptype'));
    }

    public function store(CreateRequest $request)
    {
        $zoneCertificateService = $this->zoneCertificateService->store($request);

        if ($zoneCertificateService) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

    public function edit(string $id)
    {
        $id = decrypt($id);
        $data = CityStructureZoneCertificate::findOrFail($id);
        $status = Status::where('table_id', $id)
        ->where('service_id', $data->service_id)
        ->first();

         $maptype = DB::table('partmapstypes')->get();


        return view('town-planing.zone-certificate.edit', compact('data','status','maptype'));
    }

    public function update(UpdateRequest $request, string $id)
    {
        $zoneCertificateService = $this->zoneCertificateService->update($request, $id);

        if ($zoneCertificateService) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

     public function show($id)
    {
        $data = CityStructureZoneCertificate::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('town-planing.zone-certificate.zonecertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

      public function generateReceipt($id)
    {
        $data = CityStructureZoneCertificate::with('user')->findOrFail(decrypt($id));

        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();

        $pdf = SnappyPdf::loadView('town-planing.bhag-nakasha.receipt', ['data' => $data,
        'paymentdata' => $paymentdata
        ]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
