<?php

namespace App\Http\Controllers\Trade;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Services\Trade\AutoRenewalService;
use App\Http\Requests\Trade\AutoRenewal\CreateRequest;
use App\Http\Requests\Trade\AutoRenewal\UpdateRequest;
use App\Models\Trade\TradeAutoRenewalLicensePermission;


class AutoRenewalController extends Controller
{
    protected $autoRenewalService;
    protected $commonService;

    public function __construct(AutoRenewalService $autoRenewalService, CommonService $commonService)
    {
        $this->autoRenewalService = $autoRenewalService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('trade.auto-renewal.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $autoRenewalService = $this->autoRenewalService->store($request);

        if ($autoRenewalService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $autoRenewalService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
         $id = decrypt($id);
        $data = TradeAutoRenewalLicensePermission::findOrFail($id);

         $status = Status::where('table_id', $id)
        ->where('service_id', $data->service_id)
        ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('trade.auto-renewal.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $autoRenewalService = $this->autoRenewalService->update($request, $id);

        if ($autoRenewalService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $autoRenewalService[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = TradeAutoRenewalLicensePermission::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('trade.auto-renewal.autorenewalcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = TradeAutoRenewalLicensePermission::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('trade.auto-renewal.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }

}
