<?php

namespace App\Http\Controllers\Trade;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\Trade\IssuanceLicenseMarriage;




use App\Services\Trade\IssuanceLicenseMarriageService;
use App\Http\Requests\Trade\IssuanceLicenseMarrage\CreateRequest;
use App\Http\Requests\Trade\IssuanceLicenseMarrage\UpdateRequest;

class IssuanceLicenseMarriageController extends Controller
{
    protected $commonService;
    protected $issueLicenseMarriage;


    public function __construct(IssuanceLicenseMarriageService $issueLicenseMarriage, CommonService $commonService)
    {
        $this->issueLicenseMarriage = $issueLicenseMarriage;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('trade.issuance-marriage.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    // Store the newly created abattoir license
    public function store(CreateRequest $request)
    {

        $issueLicenseMarriage = $this->issueLicenseMarriage->store($request);
        if ($issueLicenseMarriage[0]) {
            return response()->json([
                'success' => 'Issuance  Marriage License saved successfully'
            ]);
        } else {
            return response()->json([
                'error' => $issueLicenseMarriage[1]
            ]);
        }
    }



    public function edit($id)
    {
        $id = decrypt($id);
        $issueLicenseMarriage = IssuanceLicenseMarriage::findOrFail($id);

        $status = Status::where('table_id', $id)
        ->where('service_id', $issueLicenseMarriage->service_id)
        ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('trade.issuance-marriage.update')->with([
            'issueLicenseMarriage'=>  $issueLicenseMarriage,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status,
        ]);
    }
    public function update(UpdateRequest $request, $id)
    {
        // dd($request->all());
        $trade = $this->issueLicenseMarriage->update($request, $id);

        if ($trade) {
            return response()->json([
                'success' => 'Issuance  Marriage License updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

      public function show($id)
    {
        $data = IssuanceLicenseMarriage::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('trade.issuance-marriage.issuancecertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = IssuanceLicenseMarriage::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('trade.issuance-marriage.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
