<?php

namespace App\Http\Controllers\Trade;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\Trade\TradeLicenseCancellation;
use App\Services\Trade\LicenseCancellationService;
use App\Http\Requests\Trade\LicenseCancellation\CreateRequest;
use App\Http\Requests\Trade\LicenseCancellation\UpdateRequest;


class LicenseCancellationController extends Controller
{
    protected $licenseCancellationService;
    protected $commonService;

    public function __construct(LicenseCancellationService $licenseCancellationService, CommonService $commonService)
    {
        $this->licenseCancellationService = $licenseCancellationService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();


        $zones = $this->commonService->getActiveZone();

        return view('trade.license-cancellation.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $licenseCancellationService = $this->licenseCancellationService->store($request);

        if ($licenseCancellationService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $licenseCancellationService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
         $id = decrypt($id);
        $data = TradeLicenseCancellation::findOrFail($id);

         $status = Status::where('table_id', $id)
        ->where('service_id', $data->service_id)
        ->first();

        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('trade.license-cancellation.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $licenseCancellationService = $this->licenseCancellationService->update($request, $id);

        if ($licenseCancellationService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $licenseCancellationService[1]
            ]);
        }
    }

      public function show($id)
    {
        $data = TradeLicenseCancellation::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('trade.license-cancellation.licensecancellationcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = TradeLicenseCancellation::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('trade.license-cancellation.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
