<?php

namespace App\Http\Controllers\Trade;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\Trade\LicenseLoadgingHouse;
use App\Services\Trade\LicenseLoadgingService;
use App\Http\Requests\Trade\LicenseLoadging\CreateRequest;
use App\Http\Requests\Trade\LicenseLoadging\UpdateRequest;

class LicenseLoadgingHouseController extends Controller
{
    protected $commonService;
    protected $licenseLoadgingHouse;


    public function __construct(LicenseLoadgingService $licenseLoadgingHouse, CommonService $commonService)
    {
        $this->licenseLoadgingHouse = $licenseLoadgingHouse;
        $this->commonService = $commonService;
    }

    public function create()
    {

        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();


        return view('trade.license-loadging.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        // dd($request);
        // Call the store method in the service and get the response
        $licenseLoadgingHouse = $this->licenseLoadgingHouse->store($request);

        // dd($request);
        // Check if the license was successfully saved
        if ($licenseLoadgingHouse[0]) {
            return response()->json([
                'success' => 'New License Loading House saved successfully'
            ]);
        } else {
            return response()->json([
                'error' => $licenseLoadgingHouse[1]
            ]);
        }
    }



    public function edit($id)
    {
        $id = decrypt($id);
        $licenseLoadgingHouse = LicenseLoadgingHouse::findOrFail($id);

         $status = Status::where('table_id', $id)
        ->where('service_id', $licenseLoadgingHouse->service_id)
        ->first();


        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('trade.license-loadging.update')->with([
            'licenseLoadgingHouse'=>  $licenseLoadgingHouse,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }
    public function update(UpdateRequest $request, $id)
    {
        // dd($request->all());
        $trade = $this->licenseLoadgingHouse->update($request, $id);

        if ($trade) {
            return response()->json([
                'success' => 'New License Loading House updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => 'Something went wrong, please try again'
            ]);
        }
    }

     public function show($id)
    {
        $data = LicenseLoadgingHouse::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('trade.license-loadging.licenceloadgingcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = LicenseLoadgingHouse::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('trade.license-loadging.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
