<?php

namespace App\Http\Controllers\Trade;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\Trade\TradeLicenseTransfer;
use App\Services\Trade\LicenseTransferService;
use App\Http\Requests\Trade\LicenseTransfer\CreateRequest;
use App\Http\Requests\Trade\LicenseTransfer\UpdateRequest;


class LicenseTransferController extends Controller
{
    protected $licenseTransferService;
    protected $commonService;

    public function __construct(LicenseTransferService $licenseTransferService, CommonService $commonService)
    {
        $this->licenseTransferService = $licenseTransferService;
        $this->commonService = $commonService;
    }

    public function create()
    {
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('trade.license-transfer.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }

    public function store(CreateRequest $request)
    {
        $licenseTransferService = $this->licenseTransferService->store($request);

        if ($licenseTransferService[0]) {
            return response()->json([
                'success' => 'Detail Stored successfully'
            ]);
        } else {
            return response()->json([
                'error' => $licenseTransferService[1]
            ]);
        }
    }

    public function edit(string $id)
    {
         $id = decrypt($id);
         $data = TradeLicenseTransfer::findOrFail($id);
         $status = Status::where('table_id', $id)
        ->where('service_id', $data->service_id)
        ->first();


        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();

        return view('trade.license-transfer.edit')->with([
            'data' => $data,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }

    public function update(UpdateRequest $request, string $id)
    {
        $licenseTransferService = $this->licenseTransferService->update($request, $id);

        if ($licenseTransferService[0]) {
            return response()->json([
                'success' => 'Detail updated successfully'
            ]);
        } else {
            return response()->json([
                'error' => $licenseTransferService[1]
            ]);
        }
    }

    public function show($id)
    {
        $data = TradeLicenseTransfer::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('trade.license-transfer.licensetranfercertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

     public function generateReceipt($id)
    {
        $data = TradeLicenseTransfer::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('trade.license-transfer.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
