<?php

namespace App\Http\Controllers\Trade;

use App\Models\Status;
use App\Models\SbiPayment;
use Illuminate\Http\Request;
use App\Services\CommonService;
use App\Models\Trade\MovieShooting;
use App\Http\Controllers\Controller;
use Barryvdh\Snappy\Facades\SnappyPdf;
use App\Models\AdvertisementPermission;
use App\Services\Trade\MovieShootingService;


class MovieShootingController extends Controller
{
    protected $commonService;
    protected $movieshooting;

 
    // Constructor for dependency injection
    public function __construct(MovieShootingService $movieshooting, CommonService $commonService)
    {
        $this->movieshooting = $movieshooting;
        $this->commonService = $commonService;
    }

    public function create()
    {

        $wards = $this->commonService->getActiveWard();
        $zones = $this->commonService->getActiveZone();

        return view('trade.movie-shooting.create')->with([
            'wards' => $wards,
            'zones' => $zones,
        ]);
    }


    public function store(Request $request)
    {

        $movieshooting = $this->movieshooting->store($request);

        if ($movieshooting[0]) {
            return response()->json([
                'success' => 'Movie Shooting saved successfully'
            ]);
        } else {
            return response()->json([
                'error' => $movieshooting[1]
            ]);
        }
    }



    public function edit($id)
    {
       
        $id = decrypt($id);
        $movieshooting = MovieShooting::findOrFail($id);
        $status = Status::where('table_id', $id)
        ->where('service_id', $movieshooting->service_id)
        ->first();
          
        $wards = $this->commonService->getActiveWard();

        $zones = $this->commonService->getActiveZone();


        return view('trade.movie-shooting.update')->with([
            'movieshooting'=>  $movieshooting,
            'wards' => $wards,
            'zones' => $zones,
            'status' => $status
        ]);
    }
    public function update(Request $request, $id)
    {
        // dd($request->all());
        $movieshooting = $this->movieshooting->update($request, $id);

        return response()->json(['success' => 'Movie Shooting update successfully!']);
    }

    public function show($id)
    {
        $data = MovieShooting::with('user')->findOrFail(decrypt($id));

        $pdf = SnappyPdf::loadView('trade.movie-shooting.movieshootingcertificate', ['data' => $data]);
        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');
        return $pdf->inline('certificate.pdf');
    }

    public function generateReceipt($id)
    {
        $data = MovieShooting::with('user')->findOrFail(decrypt($id));
        $paymentdata = SbiPayment::Where('table_id',$data->id)->where('service_id', $data->service_id)->first();
        $pdf = SnappyPdf::loadView('trade.movie-shooting.receipt', ['data' => $data,
           'paymentdata' => $paymentdata]);

        $pdf->setPaper('a4')
            ->setOption('margin-top', 10)
            ->setOption('margin-bottom', 10)
            ->setOption('margin-left', 5)
            ->setOption('margin-right', 5)
            ->setOption('enable-smart-shrinking', true)
            ->setOption('disable-smart-shrinking', false)
            ->setOption('no-stop-slow-scripts', true)
             // ->setOption('footer-right', now()->format('d-m-Y h:i:s'))
            ->setOption('footer-left', 'Page: [page] of [toPage]');

        return $pdf->inline('receipt.pdf');
    }
}
